/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.metrics;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.callback.CDCMetricsCallback;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.enums.CDCStatus;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCMetrics;
import java.sql.SQLException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCMetricsService {
    final Logger logger = LoggerFactory.getLogger(CDCMetricsService.class);
    @Resource
    private CDCMetricsCallback cdcMetricsCallback;
    private CDCMetrics cdcMetrics = new CDCMetrics();
    private volatile boolean shutdown = false;

    public void startMetrics() {
        this.logger.info("[cdc-metrics] start, it will start hearBeat thread");
        Thread heartBeat = new Thread(this::heartBeat);
        heartBeat.setName("cdc-heartBeat");
        heartBeat.start();
        this.logger.info("[cdc-metrics] hearBeat thread start ok...");
    }

    public void heartBeat() {
        this.shutdown = false;
        long lastHeartBeatTime = 0L;
        while (!this.shutdown) {
            try {
                this.cdcMetricsCallback.heartBeat();
                long now = System.currentTimeMillis();
                if (now - lastHeartBeatTime > 10000L) {
                    lastHeartBeatTime = now;
                    this.logger.debug("[cdc-metrics] current heartBeat timeStamps : {}", (Object)lastHeartBeatTime);
                }
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.logger.warn("[cdc-metrics] heartBeat error, message :{}", (Object)e.getMessage());
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public CDCMetrics getCdcMetrics() {
        return this.cdcMetrics;
    }

    public void callBackSuccess(long originBatchId, CDCMetrics temp, boolean isConnectSync) {
        this.cdcMetrics.setCdcUnCommitMetrics(temp.getCdcUnCommitMetrics());
        this.cdcMetrics.consumeSuccess(originBatchId, temp, isConnectSync);
        this.callback();
        this.logger.debug("[cdc-metrics] success consumer, cdcMetrics : {}, batchId : {}", JSON.toJSON((Object)temp), (Object)originBatchId);
    }

    public void callBackError(CDCStatus cdcStatus) {
        this.logger.warn("error, cdcStatus : {}", (Object)cdcStatus);
        this.cdcMetrics.getCdcAckMetrics().setCdcConsumerStatus(cdcStatus);
        this.callback();
    }

    public void backup(CDCMetrics cdcMetrics) {
        try {
            this.cdcMetricsCallback.cdcSaveLastUnCommit(cdcMetrics);
        }
        catch (Exception e) {
            this.logger.error("[cdc-metrics] back up unCommitMetrics to redis error, batch : {}, unCommitMetrics : {}", (Object)cdcMetrics.getBatchId(), JSON.toJSON((Object)cdcMetrics));
        }
    }

    public CDCMetrics query() throws SQLException {
        try {
            return this.cdcMetricsCallback.queryLastUnCommit();
        }
        catch (Exception e) {
            throw new SQLException("[cdc-metrics] query unCommitMetrics from redis error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isReadyCommit(long commitId) {
        long start = System.currentTimeMillis();
        int loops = 0;
        boolean recoverMonitor = false;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[cdc-metrics] attempt check ready to commitId , commitId : {}", (Object)commitId);
            }
            while (!this.cdcMetricsCallback.isReadyCommit(commitId)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++loops <= 1000) continue;
                recoverMonitor = true;
                loops = 0;
                this.logger.warn("[cdc-metrics] loops for wait ready commit missed current check point (10s), commitId : {}", (Object)commitId);
                this.notReady(commitId);
            }
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[cdc-metrics] success check ready to commitId, commitId : {}", (Object)commitId);
            }
            if (duration > 100L) {
                this.logger.warn("[cdc-metrics] wait for ready commitId use too much times, commitId {}, use time : {}ms", (Object)commitId, (Object)duration);
            }
            if (recoverMonitor) {
                this.notReady(-1L);
            }
        }
    }

    public void connectOk() {
        this.cdcMetrics.resetStatus();
    }

    public void newConnectCallBack() {
        this.callback();
    }

    private void notReady(long commitId) {
        this.cdcMetricsCallback.notReady(commitId);
    }

    private void callback() {
        this.cdcMetrics.getCdcAckMetrics().setLastUpdateTime(System.currentTimeMillis());
        try {
            this.logger.debug("[cdc-metrics] callback ack metrics : {}", JSON.toJSON((Object)this.cdcMetrics.getCdcAckMetrics()));
        }
        catch (Exception ex) {
            this.logger.debug("[cdc-metrics] print ack metrics error, message : {}", (Object)ex.getMessage());
        }
        try {
            this.cdcMetricsCallback.cdcAck(this.cdcMetrics.getCdcAckMetrics());
        }
        catch (Exception e) {
            try {
                this.logger.error("[cdc-metrics] callback error, metrics : {}, message : {}", JSON.toJSON((Object)this.cdcMetrics.getCdcAckMetrics()), (Object)e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

