/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.mock;

import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.SQLCdcErrorStorage;
import com.xforceplus.ultraman.oqsengine.cdc.connect.SingleCDCConnector;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.ConsumerService;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.impl.SphinxConsumerService;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.impl.SphinxSyncExecutor;
import com.xforceplus.ultraman.oqsengine.common.datasource.DataSourcePackage;
import com.xforceplus.ultraman.oqsengine.common.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.node.StaticNodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.mock.BeanInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.CommonInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.InitializationHelper;
import com.xforceplus.ultraman.oqsengine.common.mock.ReflectionUtils;
import com.xforceplus.ultraman.oqsengine.metadata.mock.MetaInitialization;
import com.xforceplus.ultraman.oqsengine.pojo.dto.EntityRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.storage.index.IndexStorage;
import com.xforceplus.ultraman.oqsengine.storage.index.sphinxql.mock.IndexInitialization;
import com.xforceplus.ultraman.oqsengine.storage.master.mock.MasterDBInitialization;
import com.xforceplus.ultraman.oqsengine.storage.pojo.OriginalEntity;
import com.xforceplus.ultraman.oqsengine.storage.pojo.search.SearchConfig;
import com.xforceplus.ultraman.oqsengine.storage.pojo.select.SelectConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import javax.sql.DataSource;

public class CdcInitialization
implements BeanInitialization {
    private static volatile CdcInitialization instance;
    private SphinxSyncExecutor sphinxSyncExecutor;
    private SQLCdcErrorStorage cdcErrorStorage;
    private SingleCDCConnector singleCDCConnector;
    private ConsumerService consumerService;
    public static final String CDC_ERRORS = "cdcerrors";

    private CdcInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CdcInitialization getInstance() throws Exception {
        if (null != instance) return instance;
        Class<CdcInitialization> clazz = CdcInitialization.class;
        synchronized (CdcInitialization.class) {
            if (null != instance) return instance;
            instance = new CdcInitialization();
            instance.init();
            InitializationHelper.add((BeanInitialization)instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() throws Exception {
        this.singleCDCConnector = new SingleCDCConnector();
        this.singleCDCConnector.init(System.getProperty("CANAL_HOST"), Integer.parseInt(System.getProperty("CANAL_PORT")), System.getProperty("CANAL_DESTINATION"), System.getProperty("CANAL_USER"), System.getProperty("CANAL_PASSWORD"));
        this.initCdcErrors();
        this.initConsumerService();
    }

    public void clear() throws Exception {
        DataSourcePackage dataSourcePackage = CommonInitialization.getInstance().getDataSourcePackage(true);
        if (null != dataSourcePackage && null != dataSourcePackage.getDevOps()) {
            for (DataSource ds : dataSourcePackage.getMaster()) {
                Connection conn = ds.getConnection();
                Statement st = conn.createStatement();
                st.executeUpdate("truncate table cdcerrors");
                st.close();
                conn.close();
            }
        }
    }

    public void destroy() throws Exception {
        this.sphinxSyncExecutor = null;
        this.cdcErrorStorage = null;
        this.singleCDCConnector = null;
        this.consumerService = null;
        instance = null;
    }

    public void useMock() throws IllegalAccessException {
        Collection fields = ReflectionUtils.printAllMembers((Object)this.sphinxSyncExecutor);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"sphinxQLIndexStorage", (Object)this.sphinxSyncExecutor, (Object)new SwitchErrorThrowIndexStorage());
    }

    public void useReal() throws Exception {
        Collection fields = ReflectionUtils.printAllMembers((Object)this.sphinxSyncExecutor);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"sphinxQLIndexStorage", (Object)this.sphinxSyncExecutor, (Object)IndexInitialization.getInstance().getIndexStorage());
    }

    private void initCdcErrors() throws Exception {
        DataSource devOpsDataSource = this.buildDevOpsDataSource();
        this.cdcErrorStorage = new SQLCdcErrorStorage();
        Collection fields = ReflectionUtils.printAllMembers((Object)this.cdcErrorStorage);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"devOpsDataSource", (Object)this.cdcErrorStorage, (Object)devOpsDataSource);
        this.cdcErrorStorage.setCdcErrorRecordTable(CDC_ERRORS);
        this.cdcErrorStorage.init();
    }

    private void initConsumerService() throws Exception {
        this.sphinxSyncExecutor = new SphinxSyncExecutor();
        Collection fields = ReflectionUtils.printAllMembers((Object)this.sphinxSyncExecutor);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"sphinxQLIndexStorage", (Object)this.sphinxSyncExecutor, (Object)IndexInitialization.getInstance().getIndexStorage());
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"masterStorage", (Object)this.sphinxSyncExecutor, (Object)MasterDBInitialization.getInstance().getMasterStorage());
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"cdcErrorStorage", (Object)this.sphinxSyncExecutor, (Object)this.cdcErrorStorage);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"seqNoGenerator", (Object)this.sphinxSyncExecutor, (Object)new SnowflakeLongIdGenerator((NodeIdGenerator)new StaticNodeIdGenerator(0)));
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"metaManager", (Object)this.sphinxSyncExecutor, (Object)MetaInitialization.getInstance().getMetaManager());
        this.consumerService = new SphinxConsumerService();
        ReflectionUtils.reflectionFieldValue((Collection)ReflectionUtils.printAllMembers((Object)this.consumerService), (String)"sphinxSyncExecutor", (Object)this.consumerService, (Object)this.sphinxSyncExecutor);
    }

    private DataSource buildDevOpsDataSource() throws IllegalAccessException {
        return CommonInitialization.getInstance().getDataSourcePackage(true).getDevOps();
    }

    public SphinxSyncExecutor getSphinxSyncExecutor() {
        return this.sphinxSyncExecutor;
    }

    public SQLCdcErrorStorage getCdcErrorStorage() {
        return this.cdcErrorStorage;
    }

    public SingleCDCConnector getSingleCDCConnector() {
        return this.singleCDCConnector;
    }

    public ConsumerService getConsumerService() {
        return this.consumerService;
    }

    protected static class SwitchErrorThrowIndexStorage
    implements IndexStorage {
        public int error = 0;

        protected SwitchErrorThrowIndexStorage() {
        }

        public long clean(IEntityClass entityClass, long maintainId, long start, long end) throws SQLException {
            return 0L;
        }

        public void saveOrDeleteOriginalEntities(Collection<OriginalEntity> originalEntities) throws SQLException {
            ++this.error;
            if (this.error < 3) {
                throw new SQLException("mock error");
            }
        }

        public Collection<EntityRef> select(Conditions conditions, IEntityClass entityClass, SelectConfig config) throws SQLException {
            return null;
        }

        public Collection<EntityRef> search(SearchConfig config, IEntityClass ... entityClasses) throws SQLException {
            return null;
        }
    }
}

