/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.connect;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.protocol.Message;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCDCConnector {
    final Logger logger = LoggerFactory.getLogger(AbstractCDCConnector.class);
    private int batchSize = 2048;
    protected CanalConnector canalConnector;
    private boolean isClosed = true;
    protected String connectString;
    protected String destination;
    protected String userName;
    protected String password;

    public AbstractCDCConnector(String connectString, String destination, String userName, String password) {
        this.connectString = connectString;
        this.destination = destination;
        this.userName = userName;
        this.password = password;
    }

    public boolean canUseConnector(int times) {
        return times < 10;
    }

    public abstract void init();

    public void shutdown() {
        try {
            if (this.canalConnector.checkValid()) {
                this.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[cdc-connector] shutdown error, message : {}", (Object)e.getMessage());
        }
    }

    public void open() {
        if (null != this.canalConnector) {
            this.canalConnector.connect();
            this.canalConnector.subscribe();
            this.logger.info("[cdc-connector] connect to canal server...");
            this.isClosed = false;
        }
    }

    public void close() {
        if (null != this.canalConnector && !this.isClosed) {
            try {
                this.logger.info("[cdc-connector] close canal connector...");
                this.canalConnector.disconnect();
            }
            catch (Exception e) {
                this.logger.error("[cdc-connector] close error, ex : {}", (Object)e.getMessage());
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public void rollback() {
        if (null != this.canalConnector) {
            this.canalConnector.rollback();
        }
    }

    public void ack(long batchId) throws SQLException {
        if (null == this.canalConnector) {
            this.notInitException();
        }
        this.canalConnector.ack(batchId);
    }

    public Message getMessageWithoutAck() throws SQLException {
        if (null == this.canalConnector) {
            this.notInitException();
        }
        return this.canalConnector.getWithoutAck(this.batchSize);
    }

    private void notInitException() throws SQLException {
        throw new SQLException("[cdc-connector] canal connector not init.");
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

