package com.xforceplus.ultraman.oqsengine.cdc.consumer.checker;

import static com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService.INVALID_COMMITID;

import com.xforceplus.ultraman.oqsengine.common.thread.PollingThreadExecutor;
import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
import com.xforceplus.ultraman.oqsengine.storage.index.IndexStorage;
import com.xforceplus.ultraman.oqsengine.storage.transaction.commit.CommitHelper;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by justin.xu on 04/2023.
 *
 * @since 1.8
 */
public class CommitIdObsoleteChecker implements CommitIdChecker {

    final Logger logger = LoggerFactory.getLogger(CommitIdObsoleteChecker.class);

    private boolean openChecker = false;

    private static final long TOLERANCE = 100;

    @Resource
    private CommitIdStatusService commitIdStatusService;

    @Resource(name = "indexStorage")
    private IndexStorage sphinxQLIndexStorage;

    private PollingThreadExecutor pollingThreadExecutor;

    public void setOpenChecker(boolean openChecker) {
        this.openChecker = openChecker;
    }

    @Override
    public void init() {
        if (openChecker) {
            pollingThreadExecutor = new PollingThreadExecutor(
                "commitIdChecker",
                120,
                TimeUnit.SECONDS, 10,
                (n) -> checkCommitId(),
                null);

            pollingThreadExecutor.start();
        }
    }

    @Override
    public void destroy() {
        if (openChecker && null != pollingThreadExecutor) {
            pollingThreadExecutor.stop();
        }
    }


    private void checkCommitId() {
        try {
            long indexId = sphinxQLIndexStorage.commitIdCheck();
            if (indexId != -1) {
                while (true) {
                    long minId = commitIdStatusService.getMin();
                    boolean isLegal = isLegaCommitId(minId);
                    if (isLegal || minId + TOLERANCE > indexId) {
                        if (isLegal) {
                            logger.info("not obsolete commit-id {} , current index max id is {}", minId, indexId);
                        }
                        break;
                    } else {
                        logger.info("commit-id {} is obsolete, current index max id is {}", minId, indexId);
                        commitIdStatusService.obsolete(minId);
                    }
                }
            }
        } catch (SQLException ex) {
            //   ignore...
        }
    }

    private boolean isLegaCommitId(long commitId) {
        return commitId == INVALID_COMMITID;
    }
}
