package com.xforceplus.ultraman.oqsengine.cdc.consumer.dto;

/**
 * Created by justin.xu on 02/2023.
 *
 * @since 1.8
 */
public enum ConsumerType {
    MIXED(1),
    DATA_MIGRATION(2),
    EXCLUDE_MIGRATION(3);

    private int type;

    ConsumerType(int type) {
        this.type = type;
    }

    /**
     * get instance.
     *
     * @param consumerType  类型.
     * @return  ConsumerType.
     */
    public static ConsumerType instance(int consumerType) {
        for (ConsumerType c : ConsumerType.values()) {
            if (c.getType() == consumerType) {
                return c;
            }
        }

        return MIXED;
    }

    public int getType() {
        return type;
    }
}
