/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc;

import com.xforceplus.ultraman.oqsengine.cdc.connect.AbstractCDCConnector;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.CDCRunner;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.process.BatchProcessor;
import com.xforceplus.ultraman.oqsengine.common.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.lifecycle.Lifecycle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCDaemonService
implements Lifecycle {
    final Logger logger = LoggerFactory.getLogger(CDCDaemonService.class);
    @Resource(name="nodeIdGenerator")
    private NodeIdGenerator nodeIdGenerator;
    @Resource
    private AbstractCDCConnector cdcConnector;
    @Resource
    private BatchProcessor batchProcessor;
    private CDCRunner cdcRunner;
    private static boolean isStart = false;

    @PostConstruct
    public void init() throws Exception {
        Integer nodeId = (Integer)this.nodeIdGenerator.next();
        this.logger.info("[cdc-daemon] current node = {}", (Object)nodeId);
        if (nodeId == 0 && !isStart) {
            this.logger.info("[cdc-daemon] node-{} start cdc daemon process thread...", (Object)nodeId);
            this.cdcRunner = new CDCRunner(this.batchProcessor, this.cdcConnector);
            this.cdcRunner.start();
            isStart = true;
            this.logger.info("[cdc-daemon] node-{} start cdc daemon process thread success...", (Object)nodeId);
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        if (isStart) {
            this.logger.info("[cdc-daemon] try close cdc daemon process thread...");
            this.cdcRunner.shutdown();
            isStart = false;
            this.logger.info("[cdc-daemon] try close cdc daemon process thread success...");
        }
    }
}

