/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.cdcerror;

import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.CdcErrorStorage;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.condition.CdcErrorQueryCondition;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.CdcErrorBatchInsertExecutor;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.CdcErrorBatchQueryExecutor;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.CdcErrorBuildExecutor;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.CdcErrorQueryExecutor;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.CdcErrorUpdateStatusExecutor;
import com.xforceplus.ultraman.oqsengine.pojo.devops.CdcErrorTask;
import com.xforceplus.ultraman.oqsengine.pojo.devops.FixedStatus;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;

public class SQLCdcErrorStorage
implements CdcErrorStorage {
    @Resource(name="devOpsDataSource")
    private DataSource devOpsDataSource;
    private String cdcErrorRecordTable;
    private long queryTimeout;

    public void setCdcErrorRecordTable(String cdcErrorRecordTable) {
        this.cdcErrorRecordTable = cdcErrorRecordTable;
    }

    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @PostConstruct
    public void init() {
        if (this.queryTimeout <= 0L) {
            this.setQueryTimeout(10000L);
        }
    }

    @Override
    public int buildCdcError(CdcErrorTask cdcErrorTask) throws SQLException {
        return CdcErrorBuildExecutor.build(this.cdcErrorRecordTable, this.devOpsDataSource, this.queryTimeout).execute(cdcErrorTask);
    }

    @Override
    public int updateCdcErrorStatus(long seqNo, FixedStatus fixedStatus) throws SQLException {
        return CdcErrorUpdateStatusExecutor.build(this.cdcErrorRecordTable, this.devOpsDataSource, this.queryTimeout, fixedStatus).execute(seqNo);
    }

    @Override
    public Collection<CdcErrorTask> queryCdcErrors(CdcErrorQueryCondition res) throws SQLException {
        return CdcErrorQueryExecutor.build(this.cdcErrorRecordTable, this.devOpsDataSource, this.queryTimeout).execute(res);
    }

    @Override
    public Collection<CdcErrorTask> queryCdcErrors(List<String> res) throws SQLException {
        return CdcErrorBatchQueryExecutor.build(this.cdcErrorRecordTable, this.devOpsDataSource, this.queryTimeout).execute(res);
    }

    @Override
    public boolean batchInsert(Collection<CdcErrorTask> errorTasks) throws SQLException {
        return CdcErrorBatchInsertExecutor.build(this.cdcErrorRecordTable, this.devOpsDataSource, this.queryTimeout).execute(errorTasks);
    }
}

