/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl;

import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.CdcErrorExecutor;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.AbstractDevOpsExecutor;
import com.xforceplus.ultraman.oqsengine.pojo.devops.CdcErrorTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;

public class CdcErrorBatchInsertExecutor
extends AbstractDevOpsExecutor<Collection<CdcErrorTask>, Boolean> {
    private static final String VALUES_TEMPLATE = "(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public CdcErrorBatchInsertExecutor(String tableName, DataSource dataSource, long timeoutMs) {
        super(tableName, dataSource, timeoutMs);
    }

    public static CdcErrorExecutor<Collection<CdcErrorTask>, Boolean> build(String tableName, DataSource dataSource, long timeoutMs) {
        return new CdcErrorBatchInsertExecutor(tableName, dataSource, timeoutMs);
    }

    @Override
    public Boolean execute(Collection<CdcErrorTask> cdcErrors) throws SQLException {
        String sql = this.buildSql(cdcErrors.size());
        try (Connection connection = this.getDataSource().getConnection();){
            Boolean bl;
            block15: {
                PreparedStatement st = connection.prepareStatement(sql);
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(st.toString());
                    }
                    for (CdcErrorTask res : cdcErrors) {
                        int pos = 1;
                        st.setLong(pos++, res.getSeqNo());
                        st.setString(pos++, res.getUniKey());
                        st.setLong(pos++, res.getBatchId());
                        st.setLong(pos++, res.getId());
                        st.setLong(pos++, res.getEntity());
                        st.setInt(pos++, res.getVersion());
                        st.setInt(pos++, res.getOp());
                        st.setLong(pos++, res.getCommitId());
                        st.setInt(pos++, res.getErrorType());
                        st.setInt(pos++, res.getStatus());
                        st.setString(pos++, res.getOperationObject());
                        st.setString(pos++, res.getMessage());
                        st.setLong(pos++, res.getExecuteTime());
                        st.setLong(pos, res.getFixedTime());
                        st.addBatch();
                    }
                    int[] flags = st.executeBatch();
                    int success = 0;
                    for (int i = 0; i < flags.length; ++i) {
                        if (flags[i] <= 0 && flags[i] != -2) continue;
                        ++success;
                    }
                    bl = success == cdcErrors.size();
                    if (st == null) break block15;
                }
                catch (Throwable throwable) {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st.close();
            }
            return bl;
        }
    }

    private String buildSql(int size) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(this.getTableName()).append(" (").append(String.join((CharSequence)",", "seqno", "unikey", "batchid", "id", "entity", "version", "op", "commitid", "type", "status", "operationobject", "message", "executetime", "fixedtime")).append(") VALUES ").append(VALUES_TEMPLATE);
        return sql.toString();
    }
}

