/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl;

import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.CdcErrorExecutor;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.AbstractDevOpsExecutor;
import com.xforceplus.ultraman.oqsengine.pojo.devops.CdcErrorTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class CdcErrorBatchQueryExecutor
extends AbstractDevOpsExecutor<Collection<String>, Collection<CdcErrorTask>> {
    public CdcErrorBatchQueryExecutor(String tableName, DataSource dataSource, long timeoutMs) {
        super(tableName, dataSource, timeoutMs);
    }

    public static CdcErrorExecutor<Collection<String>, Collection<CdcErrorTask>> build(String tableName, DataSource dataSource, long timeoutMs) {
        return new CdcErrorBatchQueryExecutor(tableName, dataSource, timeoutMs);
    }

    @Override
    public Collection<CdcErrorTask> execute(Collection<String> res) throws SQLException {
        if (res.isEmpty()) {
            return Collections.emptyList();
        }
        String sql = String.format(this.buildSQL(), res.stream().map(e -> "'" + e + "'").collect(Collectors.joining(",")));
        try (Connection connection = this.getDataSource().getConnection();){
            ArrayList<CdcErrorTask> arrayList;
            block15: {
                PreparedStatement st = connection.prepareStatement(sql);
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(st.toString());
                    }
                    ResultSet rs = null;
                    ArrayList<CdcErrorTask> cdcErrorTasks = new ArrayList<CdcErrorTask>();
                    rs = st.executeQuery();
                    CdcErrorTask cdcErrorTask = null;
                    while (rs.next()) {
                        cdcErrorTask = new CdcErrorTask();
                        cdcErrorTask.setSeqNo(rs.getLong("seqno"));
                        cdcErrorTask.setUniKey(rs.getString("unikey"));
                        cdcErrorTask.setBatchId(rs.getLong("batchid"));
                        cdcErrorTask.setId(rs.getLong("id"));
                        cdcErrorTask.setEntity(rs.getLong("entity"));
                        cdcErrorTask.setVersion(rs.getInt("version"));
                        cdcErrorTask.setOp(rs.getInt("op"));
                        cdcErrorTask.setCommitId(rs.getLong("commitid"));
                        cdcErrorTask.setErrorType(rs.getInt("type"));
                        cdcErrorTask.setStatus(rs.getInt("status"));
                        cdcErrorTask.setOperationObject(rs.getString("operationobject"));
                        cdcErrorTask.setMessage(rs.getString("message"));
                        cdcErrorTask.setExecuteTime(rs.getLong("executetime"));
                        cdcErrorTask.setFixedTime(rs.getLong("fixedtime"));
                        cdcErrorTasks.add(cdcErrorTask);
                    }
                    arrayList = cdcErrorTasks;
                    if (st == null) break block15;
                }
                catch (Throwable throwable) {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st.close();
            }
            return arrayList;
        }
    }

    private String buildSQL() {
        StringBuilder buff = new StringBuilder();
        buff.append("SELECT ").append(String.join((CharSequence)",", "seqno", "unikey", "batchid", "id", "entity", "version", "op", "commitid", "type", "status", "operationobject", "message", "executetime", "fixedtime")).append(" FROM ").append(this.getTableName()).append(" WHERE ").append("unikey").append(" IN (%s) ").append("order by ").append("executetime").append(" desc");
        return buff.toString();
    }
}

