/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl;

import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.CdcErrorExecutor;
import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.executor.impl.AbstractDevOpsExecutor;
import com.xforceplus.ultraman.oqsengine.pojo.devops.FixedStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;

public class CdcErrorUpdateStatusExecutor
extends AbstractDevOpsExecutor<Long, Integer> {
    private FixedStatus fixedStatus;

    public CdcErrorUpdateStatusExecutor(String tableName, DataSource dataSource, long timeoutMs, FixedStatus fixedStatus) {
        super(tableName, dataSource, timeoutMs);
        this.fixedStatus = fixedStatus;
    }

    public static CdcErrorExecutor<Long, Integer> build(String tableName, DataSource dataSource, long timeout, FixedStatus fixedStatus) {
        return new CdcErrorUpdateStatusExecutor(tableName, dataSource, timeout, fixedStatus);
    }

    @Override
    public Integer execute(Long res) throws SQLException {
        String sql = this.buildSQL();
        try (Connection connection = this.getDataSource().getConnection();){
            Integer n;
            block13: {
                PreparedStatement st = connection.prepareStatement(sql);
                try {
                    st.setInt(1, this.fixedStatus.getStatus());
                    st.setLong(2, System.currentTimeMillis());
                    st.setLong(3, res);
                    this.checkTimeout(st);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(st.toString());
                    }
                    n = st.executeUpdate();
                    if (st == null) break block13;
                }
                catch (Throwable throwable) {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st.close();
            }
            return n;
        }
    }

    private String buildSQL() {
        StringBuilder buff = new StringBuilder();
        buff.append("UPDATE ").append(this.getTableName()).append(" SET ").append("status").append("=").append("?");
        buff.append(", ").append("fixedtime").append("=").append("?");
        buff.append(" WHERE ").append("seqno").append("=").append("?");
        return buff.toString();
    }
}

