/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.consumer.checker;

import com.xforceplus.ultraman.oqsengine.cdc.consumer.checker.CommitIdChecker;
import com.xforceplus.ultraman.oqsengine.common.thread.PollingThreadExecutor;
import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
import com.xforceplus.ultraman.oqsengine.storage.index.IndexStorage;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitIdObsoleteChecker
implements CommitIdChecker {
    final Logger logger = LoggerFactory.getLogger(CommitIdObsoleteChecker.class);
    private boolean openChecker = false;
    private static final long TOLERANCE = 100L;
    @Resource
    private CommitIdStatusService commitIdStatusService;
    @Resource(name="indexStorage")
    private IndexStorage sphinxQLIndexStorage;
    private PollingThreadExecutor pollingThreadExecutor;

    public void setOpenChecker(boolean openChecker) {
        this.openChecker = openChecker;
    }

    public void init() {
        if (this.openChecker) {
            this.pollingThreadExecutor = new PollingThreadExecutor("commitIdChecker", 120, TimeUnit.SECONDS, 10, n -> this.checkCommitId(), null);
            this.pollingThreadExecutor.start();
        }
    }

    public void destroy() {
        if (this.openChecker && null != this.pollingThreadExecutor) {
            this.pollingThreadExecutor.stop();
        }
    }

    private void checkCommitId() {
        block5: {
            try {
                long indexId = this.sphinxQLIndexStorage.commitIdCheck();
                if (indexId == -1L) break block5;
                while (true) {
                    long minId;
                    boolean isLegal;
                    if ((isLegal = this.isLegaCommitId(minId = this.commitIdStatusService.getMin())) || minId + 100L > indexId) {
                        if (isLegal) {
                            this.logger.info("not obsolete commit-id {} , current index max id is {}", (Object)minId, (Object)indexId);
                        }
                        break;
                    }
                    this.logger.info("commit-id {} is obsolete, current index max id is {}", (Object)minId, (Object)indexId);
                    this.commitIdStatusService.obsolete(new long[]{minId});
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean isLegaCommitId(long commitId) {
        return commitId == 0L;
    }
}

