/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.consumer.tools;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class ColumnsUtils {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;
    private static final Map<FieldType, BiFunction<List<CanalEntry.Column>, String, Object>> STATIC_HANDLER = new HashMap<FieldType, BiFunction<List<CanalEntry.Column>, String, Object>>();

    public static Object execute(List<CanalEntry.Column> columns, String code, FieldType fieldType) {
        BiFunction<List<CanalEntry.Column>, String, Object> func = STATIC_HANDLER.get(fieldType);
        if (null == func) {
            return null;
        }
        return func.apply(columns, code);
    }

    private static String parseStringType(List<CanalEntry.Column> columns, String code) {
        for (CanalEntry.Column column : columns) {
            if (!column.hasName() || !column.getName().equals(code)) continue;
            return column.getValue();
        }
        return "";
    }

    private static Long parseLongType(List<CanalEntry.Column> columns, String code) {
        String str = ColumnsUtils.parseStringType(columns, code);
        if (!str.isEmpty()) {
            return Long.parseLong(str);
        }
        return null;
    }

    private static String parseBigDecimalType(List<CanalEntry.Column> columns, String code) {
        return ColumnsUtils.parseStringType(columns, code);
    }

    private static Long parseBooleanType(List<CanalEntry.Column> columns, String code) {
        String str = ColumnsUtils.parseStringType(columns, code);
        if (!str.isEmpty()) {
            if (str.equalsIgnoreCase("true") || StringUtils.isNumeric((CharSequence)str) && Integer.parseInt(str) > 0) {
                return 1L;
            }
            return 0L;
        }
        return null;
    }

    private static Long parseDateTimeType(List<CanalEntry.Column> columns, String code) {
        String str = ColumnsUtils.parseStringType(columns, code);
        if (!str.isEmpty()) {
            return ColumnsUtils.toEpochMilli(str);
        }
        return null;
    }

    private static String parseEnumType(List<CanalEntry.Column> columns, String code) {
        return ColumnsUtils.parseStringType(columns, code);
    }

    public static Long toEpochMilli(String strTime) {
        if (null == strTime) {
            return null;
        }
        return LocalDateTime.parse(strTime, DATE_TIME_FORMATTER).atZone(DateTimeValue.ZONE_ID).toInstant().toEpochMilli();
    }

    static {
        STATIC_HANDLER.put(FieldType.STRING, ColumnsUtils::parseStringType);
        STATIC_HANDLER.put(FieldType.LONG, ColumnsUtils::parseLongType);
        STATIC_HANDLER.put(FieldType.BOOLEAN, ColumnsUtils::parseBooleanType);
        STATIC_HANDLER.put(FieldType.DECIMAL, ColumnsUtils::parseBigDecimalType);
        STATIC_HANDLER.put(FieldType.DATETIME, ColumnsUtils::parseDateTimeType);
        STATIC_HANDLER.put(FieldType.ENUM, ColumnsUtils::parseEnumType);
    }
}

