/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.consumer.tools;

import com.xforceplus.ultraman.oqsengine.cdc.context.ParserContext;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Set;

public class CommonUtils {
    public static IEntityClass getEntityClass(EntityClassRef entityClassRef, ParserContext parserContext) throws SQLException {
        String key = ParserContext.entityClassKey(entityClassRef);
        IEntityClass entityClass = parserContext.entityClasses().get(key);
        if (null != entityClass) {
            return entityClass;
        }
        Optional entityClassOptional = parserContext.getMetaManager().load(entityClassRef.getId(), entityClassRef.getProfile());
        if (entityClassOptional.isPresent()) {
            entityClass = (IEntityClass)entityClassOptional.get();
            parserContext.entityClasses().put(key, entityClass);
            return entityClass;
        }
        throw new SQLException(String.format("[common-utils] id : %d, profile : %s has no entityClass...", entityClassRef.getId(), entityClassRef.getProfile()));
    }

    public static String toErrorCommitIdStr(Set<Long> commitIds, Set<Long> unCommitIds) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(commitIds);
        if (!unCommitIds.isEmpty()) {
            stringBuilder.append(unCommitIds);
        }
        return stringBuilder.toString();
    }
}

