/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.mock;

import com.xforceplus.ultraman.oqsengine.cdc.cdcerror.SQLCdcErrorStorage;
import com.xforceplus.ultraman.oqsengine.cdc.connect.SingleCDCConnector;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.checker.CommitIdObsoleteChecker;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.error.DefaultErrorRecorder;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.error.ErrorRecorder;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.process.BatchProcessor;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.process.DefaultBatchProcessor;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.service.ConsumerService;
import com.xforceplus.ultraman.oqsengine.cdc.consumer.service.DefaultConsumerService;
import com.xforceplus.ultraman.oqsengine.cdc.metrics.CDCMetricsHandler;
import com.xforceplus.ultraman.oqsengine.cdc.metrics.DefaultCDCMetricsHandler;
import com.xforceplus.ultraman.oqsengine.cdc.mock.MockCallBackService;
import com.xforceplus.ultraman.oqsengine.common.datasource.DataSourcePackage;
import com.xforceplus.ultraman.oqsengine.common.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.node.StaticNodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.mock.BeanInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.CommonInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.InitializationHelper;
import com.xforceplus.ultraman.oqsengine.common.mock.ReflectionUtils;
import com.xforceplus.ultraman.oqsengine.metadata.mock.MetaInitialization;
import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
import com.xforceplus.ultraman.oqsengine.storage.index.sphinxql.mock.IndexInitialization;
import com.xforceplus.ultraman.oqsengine.storage.mock.StorageInitialization;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collection;
import javax.sql.DataSource;

public class CdcInitialization
implements BeanInitialization {
    private static volatile CdcInitialization instance;
    private SQLCdcErrorStorage cdcErrorStorage;
    private SingleCDCConnector singleCDCConnector;
    private CDCMetricsHandler cdcMetricsHandler;
    private ConsumerService consumerService;
    private BatchProcessor batchProcessor;
    private CommitIdObsoleteChecker commitIdObsoleteChecker;
    private MockCallBackService mockCallBackService;
    private ErrorRecorder errorRecorder;
    private DataSource devOpsDataSource;
    public static final String CDC_ERRORS = "cdcerrors";

    private CdcInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CdcInitialization getInstance() throws Exception {
        if (null != instance) return instance;
        Class<CdcInitialization> clazz = CdcInitialization.class;
        synchronized (CdcInitialization.class) {
            if (null != instance) return instance;
            instance = new CdcInitialization();
            instance.init();
            InitializationHelper.add((BeanInitialization)instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() throws Exception {
        this.singleCDCConnector = new SingleCDCConnector(System.getProperty("CANAL_HOST"), System.getProperty("CANAL_DESTINATION"), System.getProperty("CANAL_USER"), System.getProperty("CANAL_PASSWORD"), Integer.parseInt(System.getProperty("CANAL_PORT")));
        this.singleCDCConnector.init();
        this.initCdcErrors();
        this.initMetrics();
        this.initConsumerService();
        this.initBatchProcessor();
    }

    public void clear() throws Exception {
        if (null != this.mockCallBackService) {
            this.mockCallBackService.reset();
        }
        DataSourcePackage dataSourcePackage = CommonInitialization.getInstance().getDataSourcePackage(false);
        try {
            if (null != dataSourcePackage && null != dataSourcePackage.getDevOps()) {
                for (DataSource ds : dataSourcePackage.getMaster()) {
                    Connection conn = ds.getConnection();
                    Statement st = conn.createStatement();
                    st.execute("truncate table cdcerrors");
                    st.close();
                    conn.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() throws Exception {
        this.cdcErrorStorage = null;
        this.singleCDCConnector = null;
        this.cdcMetricsHandler = null;
        this.mockCallBackService = null;
        this.consumerService = null;
        if (null != this.commitIdObsoleteChecker) {
            this.commitIdObsoleteChecker.destroy();
        }
        this.errorRecorder = null;
        this.batchProcessor = null;
        instance = null;
    }

    private void initBatchProcessor() throws Exception {
        this.commitIdObsoleteChecker = new CommitIdObsoleteChecker();
        Collection cFields = ReflectionUtils.printAllMembers((Object)this.commitIdObsoleteChecker);
        ReflectionUtils.reflectionFieldValue((Collection)cFields, (String)"sphinxQLIndexStorage", (Object)this.commitIdObsoleteChecker, (Object)IndexInitialization.getInstance().getIndexStorage());
        ReflectionUtils.reflectionFieldValue((Collection)cFields, (String)"commitIdStatusService", (Object)new CommitIdStatusService(){

            public boolean save(long commitId, boolean ready) {
                return false;
            }

            public boolean isReady(long commitId) {
                return false;
            }

            public boolean[] isReady(long[] commitIds) {
                return new boolean[0];
            }

            public void ready(long commitId) {
            }

            public long[] getUnreadiness() {
                return new long[0];
            }

            public long getMinWithKeep() {
                return 0L;
            }

            public long getMin() {
                return 0L;
            }

            public long getMax() {
                return 0L;
            }

            public long[] getAll() {
                return new long[0];
            }

            public long size() {
                return 0L;
            }

            public void obsolete(long ... commitIds) {
            }

            public void obsoleteAll() {
            }

            public boolean isObsolete(long commitId) {
                return false;
            }
        }, (Object)IndexInitialization.getInstance().getIndexStorage());
        this.batchProcessor = new DefaultBatchProcessor();
        Collection fields = ReflectionUtils.printAllMembers((Object)this.batchProcessor);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"consumerService", (Object)this.batchProcessor, (Object)this.consumerService);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"commitIdChecker", (Object)this.batchProcessor, (Object)this.commitIdObsoleteChecker);
        this.commitIdObsoleteChecker.init();
    }

    private void initCdcErrors() throws Exception {
        this.devOpsDataSource = this.buildDevOpsDataSource();
        this.cdcErrorStorage = new SQLCdcErrorStorage();
        Collection fields = ReflectionUtils.printAllMembers((Object)this.cdcErrorStorage);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"devOpsDataSource", (Object)this.cdcErrorStorage, (Object)this.devOpsDataSource);
        this.cdcErrorStorage.setCdcErrorRecordTable(CDC_ERRORS);
        this.cdcErrorStorage.init();
        this.errorRecorder = new DefaultErrorRecorder();
        Collection errorFields = ReflectionUtils.printAllMembers((Object)this.errorRecorder);
        ReflectionUtils.reflectionFieldValue((Collection)errorFields, (String)"cdcErrorStorage", (Object)this.errorRecorder, (Object)this.cdcErrorStorage);
        ReflectionUtils.reflectionFieldValue((Collection)errorFields, (String)"seqNoGenerator", (Object)this.errorRecorder, (Object)new SnowflakeLongIdGenerator((NodeIdGenerator)new StaticNodeIdGenerator(0)));
    }

    private void initMetrics() throws Exception {
        this.mockCallBackService = new MockCallBackService((CommitIdStatusService)StorageInitialization.getInstance().getCommitIdStatusService());
        this.cdcMetricsHandler = new DefaultCDCMetricsHandler();
        Collection fields = ReflectionUtils.printAllMembers((Object)this.cdcMetricsHandler);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"cdcMetricsCallback", (Object)this.cdcMetricsHandler, (Object)this.mockCallBackService);
    }

    public void initConsumerService() throws Exception {
        this.consumerService = this.initConsumer();
    }

    private DataSource buildDevOpsDataSource() throws IllegalAccessException {
        return CommonInitialization.getInstance().getDataSourcePackage(false).getDevOps();
    }

    public BatchProcessor getBatchProcessor() {
        return this.batchProcessor;
    }

    public ErrorRecorder getErrorRecorder() {
        return this.errorRecorder;
    }

    public SQLCdcErrorStorage getCdcErrorStorage() {
        return this.cdcErrorStorage;
    }

    public SingleCDCConnector getSingleCDCConnector() {
        return this.singleCDCConnector;
    }

    public CDCMetricsHandler getCdcMetricsHandler() {
        return this.cdcMetricsHandler;
    }

    public ConsumerService getConsumerService() {
        return this.consumerService;
    }

    public DataSource getDevOpsDataSource() {
        return this.devOpsDataSource;
    }

    public void resetConsumerService(ConsumerService consumerService) throws IllegalAccessException {
        this.consumerService = consumerService;
        Collection fields = ReflectionUtils.printAllMembers((Object)this.batchProcessor);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"consumerService", (Object)this.batchProcessor, (Object)this.consumerService);
    }

    public ConsumerService initConsumer() throws Exception {
        DefaultConsumerService consumerService = new DefaultConsumerService();
        Collection fields = ReflectionUtils.printAllMembers((Object)consumerService);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"sphinxQLIndexStorage", (Object)consumerService, (Object)IndexInitialization.getInstance().getIndexStorage());
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"errorRecorder", (Object)consumerService, (Object)this.errorRecorder);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"metaManager", (Object)consumerService, (Object)MetaInitialization.getInstance().getMetaManager());
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"threadPool", (Object)consumerService, (Object)CommonInitialization.getInstance().getRunner());
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"cdcMetricsHandler", (Object)consumerService, (Object)this.cdcMetricsHandler);
        return consumerService;
    }
}

