/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.cdc.mock;

import com.xforceplus.ultraman.oqsengine.cdc.consumer.callback.CDCMetricsCallback;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.enums.CDCStatus;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCAckMetrics;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCMetrics;
import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class MockCallBackService
implements CDCMetricsCallback {
    private CDCAckMetrics ackMetrics;
    private CDCMetrics cdcMetrics;
    private long heartBeat;
    private long notReady;
    private CommitIdStatusService commitIdStatusService;
    private AtomicInteger executed = new AtomicInteger(0);
    private long lastConsumerTime = 0L;

    public MockCallBackService(CommitIdStatusService commitIdStatusService) {
        this.commitIdStatusService = commitIdStatusService;
    }

    public void reset() {
        this.cdcMetrics = null;
        this.ackMetrics = null;
        this.executed = new AtomicInteger(0);
    }

    @Override
    public void ack(CDCAckMetrics ackMetrics) {
        this.ackMetrics = ackMetrics;
        if (ackMetrics.getCdcConsumerStatus() == CDCStatus.CONNECTED) {
            if (null != this.commitIdStatusService) {
                ackMetrics.getCommitList().forEach(id -> this.commitIdStatusService.obsolete(new long[]{id}));
            }
            if (this.ackMetrics.getLastConsumerTime() > this.lastConsumerTime) {
                this.executed.addAndGet(this.cdcMetrics.getCdcAckMetrics().getExecuteRows());
                this.lastConsumerTime = this.cdcMetrics.getCdcAckMetrics().getLastConsumerTime();
            }
        }
    }

    @Override
    public void heartBeat() {
        this.heartBeat = System.currentTimeMillis();
    }

    @Override
    public void notReady(long commitId) {
        this.notReady = commitId;
    }

    @Override
    public List<Long> notReady(List<Long> commitIds) {
        return new ArrayList<Long>();
    }

    @Override
    public void saveLastUnCommit(CDCMetrics cdcMetrics) {
        this.cdcMetrics = cdcMetrics;
    }

    @Override
    public CDCMetrics queryLastUnCommit() {
        return this.cdcMetrics;
    }

    @Override
    public boolean isReady(long commitId) {
        return commitId != this.notReady;
    }

    public AtomicInteger getExecuted() {
        return this.executed;
    }

    public CDCAckMetrics getAckMetrics() {
        return this.ackMetrics;
    }
}

