/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.entity;

import com.google.common.collect.Sets;
import com.xforceplus.ultraman.oqsengine.changelog.command.AddChangelog;
import com.xforceplus.ultraman.oqsengine.changelog.command.ChangelogCommand;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeSnapshot;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeVersion;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangedEvent;
import com.xforceplus.ultraman.oqsengine.changelog.domain.Changelog;
import com.xforceplus.ultraman.oqsengine.changelog.domain.EntityDomain;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ValueWrapper;
import com.xforceplus.ultraman.oqsengine.changelog.entity.StatefulEntity;
import com.xforceplus.ultraman.oqsengine.changelog.event.ChangelogEvent;
import com.xforceplus.ultraman.oqsengine.changelog.event.PersistentEvent;
import com.xforceplus.ultraman.oqsengine.changelog.event.PropagationChangelogEvent;
import com.xforceplus.ultraman.oqsengine.changelog.event.SnapshotEvent;
import com.xforceplus.ultraman.oqsengine.changelog.event.VersionEvent;
import com.xforceplus.ultraman.oqsengine.changelog.utils.ChangelogHelper;
import com.xforceplus.ultraman.oqsengine.changelog.utils.EntityClassHelper;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogStatefulEntity
implements StatefulEntity<EntityDomain, ChangelogCommand, ChangelogEvent> {
    private Logger logger = LoggerFactory.getLogger(ChangelogStatefulEntity.class);
    private long count;
    private long currentVersion;
    private long id;
    private EntityDomain entityDomain;
    private IEntityClass entityClass;
    private MetaManager metaManager;
    private long snapshotThreshold;

    public ChangelogStatefulEntity(long id, IEntityClass entityClass, MetaManager metaManager, EntityDomain entityDomain, long snapshotThreshold) {
        this.id = id;
        this.metaManager = metaManager;
        this.entityClass = entityClass;
        this.entityDomain = entityDomain;
        this.count = entityDomain.getCount();
        this.snapshotThreshold = snapshotThreshold;
        this.currentVersion = entityDomain.getVersion();
    }

    @Override
    public List<ChangelogEvent> receive(ChangelogCommand input, Map<String, Object> context) {
        LinkedList<ChangelogEvent> retList = new LinkedList<ChangelogEvent>();
        if (input instanceof AddChangelog) {
            long newVersion = ((AddChangelog)input).getChangedEvent().getCommitId();
            if (newVersion <= this.currentVersion) {
                this.logger.error("Got old version {} on {}:{}", new Object[]{newVersion, this.entityClass.id(), this.id});
                return Collections.emptyList();
            }
            ChangedEvent changedEvent = ((AddChangelog)input).getChangedEvent();
            Optional<PersistentEvent> persistentEvent = this.updateInternalState(changedEvent);
            persistentEvent.ifPresent(retList::add);
            retList.addAll(this.genPropagationEvent(changedEvent, context));
            retList.add(this.genVersionEvent(changedEvent));
            this.genSnapshotVersionEvent().ifPresent(retList::add);
        } else {
            this.logger.error("Unknown Command {}", (Object)input);
        }
        return retList;
    }

    @Override
    public EntityDomain getState() {
        return this.entityDomain;
    }

    private Optional<SnapshotEvent> genSnapshotVersionEvent() {
        if (this.count >= this.snapshotThreshold) {
            this.logger.warn("Trigger snapshot on {}", (Object)this.id);
            ChangeSnapshot changeSnapshot = new ChangeSnapshot();
            changeSnapshot.setVersion(this.currentVersion);
            changeSnapshot.setId(this.id);
            HashMap<Long, List<Long>> referenceMap = new HashMap<Long, List<Long>>();
            this.entityDomain.getReferenceMap().forEach((a, b) -> referenceMap.put(a.getEntityField().id(), (List<Long>)b));
            changeSnapshot.setReferenceMap(referenceMap);
            changeSnapshot.setChangeValues(this.stateToChangeValue());
            changeSnapshot.setVersion(this.currentVersion);
            changeSnapshot.setEntityClass(this.entityClass.id());
            changeSnapshot.setCreateTime(new DateTimeValue(null, LocalDateTime.now()).valueToLong());
            return Optional.of(new SnapshotEvent(changeSnapshot));
        }
        return Optional.empty();
    }

    private List<ChangeValue> stateToChangeValue() {
        IEntityValue entityValue = this.entityDomain.getEntity().entityValue();
        if (entityValue != null) {
            return entityValue.values().stream().map(x -> {
                ChangeValue changeValue = new ChangeValue();
                changeValue.setFieldId(x.getField().id());
                changeValue.setFieldCode(x.getField().name());
                changeValue.setOp(ChangeValue.Op.SET);
                changeValue.setRawValue(ChangelogHelper.serialize(x));
                return changeValue;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private VersionEvent genVersionEvent(ChangedEvent changedEvent) {
        ChangeVersion changeVersion = new ChangeVersion();
        changeVersion.setTimestamp(changedEvent.getTimestamp());
        changeVersion.setVersion(changedEvent.getCommitId());
        changeVersion.setComment(changedEvent.getComment());
        changeVersion.setId(this.entityDomain.getId());
        changeVersion.setSource(changedEvent.getId());
        changeVersion.setUsername(changedEvent.getUsername());
        return new VersionEvent(this.id, changeVersion);
    }

    private List<PropagationChangelogEvent> genPropagationEvent(ChangedEvent changedEvent, Map<String, Object> context) {
        Map<Long, ValueWrapper> valueMap = changedEvent.getValueMap();
        List<Relationship> propagationRelation = EntityClassHelper.findPropagationRelation(this.entityClass);
        List<Relationship> nextRelation = EntityClassHelper.findNextRelation(this.entityClass);
        List<Tuple2<Relationship, Relationship>> associatedRelations = EntityClassHelper.findAssociatedRelations(this.entityClass);
        Stream previewIdsStream = propagationRelation.stream().flatMap(x -> this.findRelatedObjIds((Relationship)x, associatedRelations, valueMap).stream());
        Stream nextIdsStream = nextRelation.stream().flatMap(x -> this.findNextObjIds((Relationship)x, valueMap).stream());
        return Stream.concat(previewIdsStream, nextIdsStream).distinct().map(x -> new PropagationChangelogEvent((Long)x._1, (Long)x._2, changedEvent, context)).collect(Collectors.toList());
    }

    private List<Tuple2<Long, Long>> findNextObjIds(Relationship relationship, Map<Long, ValueWrapper> valueMap) {
        LinkedList<Long> nextObjIds = new LinkedList<Long>();
        long entityClass = EntityClassHelper.findIdAssociatedEntityClassId(relationship);
        long id = relationship.getEntityField().id();
        Optional currentValue = this.entityDomain.getEntity().entityValue().getValue(id);
        ValueWrapper nextValue = valueMap.get(id);
        currentValue.ifPresent(iValue -> nextObjIds.add(iValue.valueToLong()));
        if (nextValue != null) {
            nextObjIds.add(nextValue.valueToLong());
        }
        return nextObjIds.stream().map(x -> Tuple.of((Object)x, (Object)entityClass)).collect(Collectors.toList());
    }

    private List<Tuple2<Long, Long>> findRelatedObjIds(Relationship relationship, List<Tuple2<Relationship, Relationship>> associatedRelations, Map<Long, ValueWrapper> valueMap) {
        Optional<Tuple2> associatedOqsRelation = associatedRelations.stream().filter(x -> ((Relationship)x._1()).equals((Object)relationship)).findAny();
        if (associatedOqsRelation.isPresent()) {
            long id = ((Relationship)associatedOqsRelation.get()._2()).getEntityField().id();
            Optional currentIdValue = this.entityDomain.getEntity().entityValue().getValue(id);
            ValueWrapper nextIdValue = valueMap.get(id);
            boolean hasOldValue = currentIdValue.isPresent();
            boolean hasNextValue = nextIdValue != null;
            Long associatedEntityClassId = EntityClassHelper.findIdAssociatedEntityClassId((Relationship)associatedOqsRelation.get()._2());
            if (hasOldValue && hasNextValue) {
                long nextId;
                long currentId = ((IValue)currentIdValue.get()).valueToLong();
                if (currentId != (nextId = nextIdValue.valueToLong().longValue())) {
                    return Arrays.asList(Tuple.of((Object)currentId, (Object)associatedEntityClassId), Tuple.of((Object)nextId, (Object)associatedEntityClassId));
                }
                return Collections.singletonList(Tuple.of((Object)currentId, (Object)associatedEntityClassId));
            }
            if (!hasOldValue && hasNextValue) {
                long nextId = nextIdValue.valueToLong();
                return Collections.singletonList(Tuple.of((Object)nextId, (Object)associatedEntityClassId));
            }
            if (hasOldValue) {
                long currentId = ((IValue)currentIdValue.get()).valueToLong();
                return Collections.singletonList(Tuple.of((Object)currentId, (Object)associatedEntityClassId));
            }
        } else {
            Long associatedEntityClassId = EntityClassHelper.findIdAssociatedEntityClassId(relationship);
            return Optional.ofNullable(this.entityDomain.getReferenceMap().get(relationship)).map(x -> x.stream().map(id -> Tuple.of((Object)id, (Object)associatedEntityClassId)).collect(Collectors.toList())).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private Changelog toRawChangelog(ChangedEvent changedEvent) {
        Changelog changelog = new Changelog();
        changelog.setId(this.entityDomain.getId());
        changelog.setEntityClass(this.entityDomain.getEntity().entityClassRef().getId());
        changelog.setVersion(changedEvent.getCommitId());
        changelog.setUsername(changedEvent.getUsername());
        changelog.setComment(changedEvent.getComment());
        changelog.setCreateTime(changedEvent.getTimestamp());
        return changelog;
    }

    private List<Long> getCurrentRelatedValue(Map<Relationship, Relationship> mapping, Relationship relationship) {
        if (mapping.get(relationship) != null) {
            long id = mapping.get(relationship).getEntityField().id();
            Optional value = this.entityDomain.getEntity().entityValue().getValue(id);
            return value.map(iValue -> Collections.singletonList(iValue.valueToLong())).orElse(Collections.emptyList());
        }
        return Optional.ofNullable(this.entityDomain.getReferenceMap().get(relationship)).orElse(Collections.emptyList());
    }

    private Long getOqsRelationRelatedId(Map<Relationship, Relationship> mapping, Relationship relationship) {
        if (mapping.get(relationship) != null) {
            long id = mapping.get(relationship).getEntityField().id();
            return id;
        }
        return relationship.getEntityField().id();
    }

    private Optional<PersistentEvent> updateRelation(ChangedEvent changedEvent) {
        long entityClassId = changedEvent.getEntityClassId();
        Optional changeRelatedEntityOp = this.metaManager.load(entityClassId, "");
        if (changeRelatedEntityOp.isPresent()) {
            IEntityClass relatedEntity = (IEntityClass)changeRelatedEntityOp.get();
            LinkedList<ChangeValue> changeValues = new LinkedList<ChangeValue>();
            List<Tuple2<Relationship, Relationship>> associatedRelations = EntityClassHelper.findAssociatedRelations(relatedEntity);
            Map<Relationship, Relationship> mapping = associatedRelations.stream().collect(Collectors.toMap(Tuple2::_1, Tuple2::_2, (a, b) -> a));
            relatedEntity.relationship().stream().filter(x -> x.getRightEntityClassId() == this.entityClass.id()).forEach(oqsRelation -> {
                if (oqsRelation.getRelationType() == Relationship.RelationType.ONE_TO_ONE) {
                    List<Long> currentRelatedValue;
                    ValueWrapper iValue = changedEvent.getValueMap().get(oqsRelation.getEntityField().id());
                    if (iValue != null && iValue.valueToLong().longValue() != this.entityDomain.getId()) {
                        ChangeValue changeValue = new ChangeValue();
                        changeValue.setRawValue(null);
                        changeValue.setReferenceSet(false);
                        changeValue.setOp(ChangeValue.Op.SET);
                        changeValue.setFieldId(this.getOqsRelationRelatedId(mapping, (Relationship)oqsRelation));
                        changeValues.add(changeValue);
                    } else if (iValue != null && iValue.valueToLong().longValue() == this.entityDomain.getId() && !(currentRelatedValue = this.getCurrentRelatedValue(mapping, (Relationship)oqsRelation)).contains(iValue.valueToLong())) {
                        ChangeValue changeValue = new ChangeValue();
                        changeValue.setRawValue(Long.toString(changedEvent.getId()));
                        changeValue.setReferenceSet(false);
                        changeValue.setOp(ChangeValue.Op.SET);
                        changeValue.setFieldId(this.getOqsRelationRelatedId(mapping, (Relationship)oqsRelation));
                        changeValues.add(changeValue);
                    }
                } else if (oqsRelation.getRelationType() == Relationship.RelationType.MANY_TO_ONE) {
                    List<Long> currentValues = this.getCurrentRelatedValue(mapping, (Relationship)oqsRelation);
                    ValueWrapper iValue = changedEvent.getValueMap().get(oqsRelation.getEntityField().id());
                    if (iValue != null) {
                        boolean currentIsRelated;
                        long currentIdValue = iValue.valueToLong();
                        long entityId = changedEvent.getId();
                        boolean alreadyHasRelatedValue = currentValues.contains(entityId);
                        boolean bl = currentIsRelated = currentIdValue == this.entityDomain.getId();
                        if (!alreadyHasRelatedValue && currentIsRelated) {
                            ChangeValue changeValue = new ChangeValue();
                            changeValue.setFieldId(this.getOqsRelationRelatedId(mapping, (Relationship)oqsRelation));
                            changeValue.setReferenceSet(true);
                            changeValue.setRawValue(Long.toString(entityId));
                            changeValue.setOp(ChangeValue.Op.ADD);
                            currentValues.add(entityId);
                            changeValues.add(changeValue);
                        } else if (alreadyHasRelatedValue && !currentIsRelated) {
                            ChangeValue changeValue = new ChangeValue();
                            changeValue.setFieldId(this.getOqsRelationRelatedId(mapping, (Relationship)oqsRelation));
                            changeValue.setReferenceSet(true);
                            changeValue.setRawValue(Long.toString(entityId));
                            changeValue.setOp(ChangeValue.Op.DEL);
                            currentValues.add(entityId);
                            changeValues.add(changeValue);
                        }
                    }
                } else if (oqsRelation.getRelationType() == Relationship.RelationType.ONE_TO_MANY) {
                    // empty if block
                }
            });
            this.updateEntityDomainRelation(changeValues);
            if (changeValues.isEmpty()) {
                return Optional.empty();
            }
            Changelog changelog = this.toRawChangelog(changedEvent);
            changelog.setChangeValues(changeValues);
            return Optional.of(new PersistentEvent(changelog));
        }
        return Optional.empty();
    }

    private void updateEntityDomainState(List<ChangeValue> changeValues) {
        changeValues.forEach(x -> {
            IEntityValue entityValue = this.entityDomain.getEntity().entityValue();
            Optional value = entityValue.getValue(x.getFieldId().longValue());
            if (value.isPresent()) {
                IValue newValue = ((IValue)value.get()).copy();
                newValue.setStringValue(x.getRawValue());
                entityValue.addValue(newValue);
            } else {
                Optional field = this.entityClass.field(x.getFieldId().longValue());
                if (field.isPresent()) {
                    IEntityField targetField = (IEntityField)field.get();
                    Optional typeValue = targetField.type().toTypedValue(targetField, x.getRawValue());
                    typeValue.ifPresent(arg_0 -> ((IEntityValue)entityValue).addValue(arg_0));
                }
            }
        });
    }

    private void updateEntityDomainRelation(List<ChangeValue> changeValues) {
        Map<Long, List<ChangeValue>> idChangesMapping = changeValues.stream().collect(Collectors.groupingBy(ChangeValue::getFieldId));
        Map<Relationship, List<Long>> referenceMap = this.entityDomain.getReferenceMap();
        idChangesMapping.forEach((a, b) -> {
            Optional<Map.Entry> related = referenceMap.entrySet().stream().filter(x -> ((Relationship)x.getKey()).getEntityField().id() == a.longValue()).findFirst();
            if (related.isPresent()) {
                ArrayList value = (ArrayList)related.get().getValue();
                if (value == null) {
                    value = new ArrayList();
                }
                ArrayList finalValue = value;
                b.forEach(changeValue -> {
                    ChangeValue.Op op = changeValue.getOp();
                    String rawValue = changeValue.getRawValue();
                    switch (op) {
                        case SET: {
                            if (finalValue.isEmpty() && rawValue != null) {
                                finalValue.add(Long.parseLong(rawValue));
                            }
                            if (finalValue.isEmpty()) break;
                            finalValue.set(0, rawValue == null ? null : Long.valueOf(Long.parseLong(rawValue)));
                            break;
                        }
                        case ADD: {
                            if (rawValue == null) break;
                            finalValue.add(Long.parseLong(rawValue));
                            break;
                        }
                        case DEL: {
                            if (rawValue == null) break;
                            finalValue.remove(Long.parseLong(rawValue));
                            break;
                        }
                    }
                });
            }
        });
    }

    private Optional<PersistentEvent> updateSelf(ChangedEvent changedEvent) {
        Map<Long, ValueWrapper> after = changedEvent.getValueMap();
        IEntityValue entityValue = this.entityDomain.getEntity().entityValue();
        if (entityValue != null) {
            Map<Long, IValue> before = entityValue.values().stream().collect(Collectors.toMap(x -> x.getField().id(), y -> y));
            List<ChangeValue> selfResult = this.compareSelf(before, this.entityDomain.getReferenceMap(), after);
            Changelog changelog = new Changelog();
            changelog.setComment(changedEvent.getComment());
            changelog.setUsername(changedEvent.getUsername());
            changelog.setCreateTime(changedEvent.getTimestamp());
            changelog.setVersion(changedEvent.getCommitId());
            changelog.setEntityClass(changedEvent.getEntityClassId());
            changelog.setId(changedEvent.getId());
            changelog.setChangeValues(selfResult);
            this.updateEntityDomainState(selfResult);
            this.updateEntityDomainRelation(selfResult);
            return Optional.of(new PersistentEvent(changelog));
        }
        Changelog changelog = new Changelog();
        changelog.setComment(changedEvent.getComment());
        changelog.setUsername(changedEvent.getUsername());
        changelog.setCreateTime(changedEvent.getTimestamp());
        changelog.setVersion(changedEvent.getCommitId());
        changelog.setEntityClass(changedEvent.getEntityClassId());
        changelog.setId(changedEvent.getId());
        List<ChangeValue> changeValues = this.genNewChangeValue(after);
        changelog.setChangeValues(changeValues);
        this.updateEntityDomainState(changeValues);
        this.updateEntityDomainRelation(changeValues);
        return Optional.of(new PersistentEvent(changelog));
    }

    private List<ChangeValue> genNewChangeValue(Map<Long, ValueWrapper> values) {
        ArrayList<ChangeValue> changeValues = new ArrayList<ChangeValue>();
        values.forEach((key, value) -> {
            ChangeValue cv = new ChangeValue();
            cv.setRawValue(value == null ? null : ChangelogHelper.serialize(value));
            cv.setOp(ChangeValue.Op.SET);
            cv.setFieldId((Long)key);
            cv.setReferenceSet(false);
            changeValues.add(cv);
        });
        return changeValues;
    }

    private synchronized Optional<PersistentEvent> updateInternalState(ChangedEvent changedEvent) {
        long changeEventOwnerId = changedEvent.getId();
        this.updateCommonState(changedEvent);
        if (changeEventOwnerId != this.entityDomain.getId()) {
            return this.updateRelation(changedEvent);
        }
        return this.updateSelf(changedEvent);
    }

    private void updateCommonState(ChangedEvent changedEvent) {
        long newVersion;
        this.currentVersion = newVersion = changedEvent.getCommitId();
        ++this.count;
    }

    private List<ChangeValue> compareSelf(Map<Long, IValue> before, Map<Relationship, List<Long>> referenceMap, Map<Long, ValueWrapper> after) {
        ArrayList<ChangeValue> changeValues = new ArrayList<ChangeValue>();
        Set<Long> beforeIds = before.keySet();
        Set<Long> afterIds = after.keySet();
        HashMap referenceMapWithIValue = new HashMap();
        referenceMap.entrySet().stream().filter(x -> {
            Relationship rel = (Relationship)x.getKey();
            return rel.getLeftEntityClassId() == this.entityClass.id() && rel.getRelationType() != Relationship.RelationType.ONE_TO_MANY;
        }).forEach(entry -> {
            Relationship key = (Relationship)entry.getKey();
            List value = (List)entry.getValue();
            if (value != null) {
                referenceMapWithIValue.put(key.getEntityField().id(), new LongValue(key.getEntityField(), ((Long)value.get(0)).longValue()));
            } else {
                referenceMapWithIValue.put(key.getEntityField().id(), null);
            }
        });
        Set referenceIdSet = referenceMapWithIValue.keySet();
        Sets.union(referenceIdSet, (Set)Sets.union(beforeIds, afterIds)).forEach(id -> {
            IValue beforeValue = (IValue)before.get(id);
            if (beforeValue == null) {
                beforeValue = (IValue)referenceMapWithIValue.get(id);
            }
            if (!after.containsKey(id)) {
                return;
            }
            ValueWrapper afterValue = (ValueWrapper)after.get(id);
            ChangeValue changeValue = new ChangeValue();
            changeValue.setFieldId((Long)id);
            if (beforeValue == null) {
                changeValue.setOp(ChangeValue.Op.SET);
                changeValue.setRawValue(ChangelogHelper.serialize(afterValue));
                changeValues.add(changeValue);
            } else if (afterValue == null) {
                changeValue.setOp(ChangeValue.Op.SET);
                changeValues.add(changeValue);
            } else {
                if (!afterValue.equals(beforeValue)) {
                    changeValue.setOp(ChangeValue.Op.SET);
                    changeValue.setRawValue(ChangelogHelper.serialize(afterValue));
                }
                changeValues.add(changeValue);
            }
        });
        return changeValues;
    }

    public String toString() {
        return "ChangelogStatefulEntity{count=" + this.count + ", currentVersion=" + this.currentVersion + ", id=" + this.id + ", entityDomain=" + this.entityDomain + ", entityClass=" + this.entityClass + ", metaManager=" + this.metaManager + ", snapshotThreshold=" + this.snapshotThreshold + '}';
    }
}

