/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.handler.impl;

import com.xforceplus.ultraman.oqsengine.changelog.ReplayService;
import com.xforceplus.ultraman.oqsengine.changelog.command.AddChangelog;
import com.xforceplus.ultraman.oqsengine.changelog.command.ChangelogCommand;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangedEvent;
import com.xforceplus.ultraman.oqsengine.changelog.entity.ChangelogStatefulEntity;
import com.xforceplus.ultraman.oqsengine.changelog.event.ChangelogEvent;
import com.xforceplus.ultraman.oqsengine.changelog.gateway.Gateway;
import com.xforceplus.ultraman.oqsengine.changelog.handler.ChangelogCommandHandler;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangelogCommandHandler
implements ChangelogCommandHandler<ChangelogCommand> {
    private Logger logger = LoggerFactory.getLogger(DefaultChangelogCommandHandler.class);
    @Resource
    private ReplayService replayService;
    @Resource
    private Gateway<ChangelogCommand, ChangelogEvent> gateway;

    @Override
    public boolean required(ChangelogCommand changelogCommand) {
        return changelogCommand != null;
    }

    @Override
    public void onCommand(ChangelogCommand command, Map<String, Object> context) {
        if (command instanceof AddChangelog) {
            long objId;
            long entityClassId;
            Optional<ChangelogStatefulEntity> changelogStatefulEntity;
            this.logger.info("Got Add Changelog Command");
            ChangedEvent changedEvent = ((AddChangelog)command).getChangedEvent();
            if (changedEvent != null && (changelogStatefulEntity = this.replayService.replayStatefulEntity(entityClassId = changedEvent.getEntityClassId(), objId = ((AddChangelog)command).getObjId())).isPresent()) {
                ChangelogStatefulEntity statefulEntity = changelogStatefulEntity.get();
                List<ChangelogEvent> changelogEvents = statefulEntity.receive(command, context);
                changelogEvents.forEach(this.gateway::dispatchEvent);
            }
        } else {
            this.logger.error("Unknown command {}", (Object)command);
        }
    }
}

