/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.handler.impl;

import com.xforceplus.ultraman.oqsengine.changelog.command.AddChangelog;
import com.xforceplus.ultraman.oqsengine.changelog.command.ChangelogCommand;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangedEvent;
import com.xforceplus.ultraman.oqsengine.changelog.event.ChangelogEvent;
import com.xforceplus.ultraman.oqsengine.changelog.event.PropagationChangelogEvent;
import com.xforceplus.ultraman.oqsengine.changelog.gateway.Gateway;
import com.xforceplus.ultraman.oqsengine.changelog.handler.ChangelogEventHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagationEventHandler
implements ChangelogEventHandler<PropagationChangelogEvent> {
    private static final String FOOTPRINT = "footprint";
    private Logger logger = LoggerFactory.getLogger(PropagationEventHandler.class);
    @Resource
    private Gateway<ChangelogCommand, ChangelogEvent> gateway;

    @Override
    public boolean required(ChangelogEvent changelogEvent) {
        return changelogEvent instanceof PropagationEventHandler;
    }

    @Override
    public void onEvent(PropagationChangelogEvent changelogEvent) {
        ChangedEvent changedEvent = changelogEvent.getChangedEvent();
        long destinationObjId = changelogEvent.getDestinationObjId();
        long entityClassId = changelogEvent.getEntityClassId();
        Map<String, Object> context = changelogEvent.getContext();
        if (this.shouldDeliver(changelogEvent)) {
            this.logger.info("deliver changelog to {}", (Object)destinationObjId);
            this.gateway.fireAndForget(new AddChangelog(destinationObjId, entityClassId, changedEvent), context);
        }
    }

    private boolean shouldDeliver(PropagationChangelogEvent changelogEvent) {
        Set footprintSet;
        Map<String, Object> context = changelogEvent.getContext();
        HashSet footprints = context.get(FOOTPRINT);
        if (footprints == null) {
            footprints = new HashSet();
            context.put(FOOTPRINT, footprints);
        }
        if ((footprintSet = (Set)footprints).contains(changelogEvent.getDestinationObjId())) {
            return false;
        }
        footprintSet.add(changelogEvent.getDestinationObjId());
        return true;
    }
}

