/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.impl;

import com.xforceplus.ultraman.oqsengine.changelog.ChangelogService;
import com.xforceplus.ultraman.oqsengine.changelog.ReplayService;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeVersion;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangedEvent;
import com.xforceplus.ultraman.oqsengine.changelog.domain.Changelog;
import com.xforceplus.ultraman.oqsengine.changelog.domain.EntityAggDomain;
import com.xforceplus.ultraman.oqsengine.changelog.domain.EntityRelation;
import com.xforceplus.ultraman.oqsengine.changelog.domain.VersiondEntityRef;
import com.xforceplus.ultraman.oqsengine.changelog.relation.RelationAwareChangelog;
import com.xforceplus.ultraman.oqsengine.changelog.storage.write.ChangelogStorage;
import com.xforceplus.ultraman.oqsengine.changelog.utils.ChangelogHelper;
import com.xforceplus.ultraman.oqsengine.common.id.IdGenerator;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultChangelogImpl
implements ChangelogService {
    @Autowired(required=false)
    private List<RelationAwareChangelog> relationAwareChangeLogs;
    @Resource
    private MetaManager metaManager;
    @Resource
    private ChangelogStorage changelogStorage;
    @Resource
    private ReplayService replayService;
    @Resource(name="longNoContinuousPartialOrderIdGenerator")
    private IdGenerator<Long> idGenerator;
    private Logger logger = LoggerFactory.getLogger(ChangelogService.class);
    private String FATAL_ERR = "Fatal Err: got non-exists entityClass:%s's changelog";

    @Override
    public Changelog generateChangeLog(IEntityClass entityClass, ChangedEvent changedEvent) {
        LinkedList<Changelog> changeLogs = new LinkedList<Changelog>();
        long entityClassId = changedEvent.getEntityClassId();
        String profile = entityClass.ref().getProfile();
        IEntityClass entityClassOp = (IEntityClass)this.metaManager.load(entityClassId, profile).orElseThrow(() -> new RuntimeException(String.format(this.FATAL_ERR, entityClassId)));
        List<Changelog> sourceChangelog = this.handleEvent(changedEvent, entityClass, null);
        changeLogs.addAll(sourceChangelog);
        List records = entityClass.relationship().stream().filter(x -> x.isCompanion()).flatMap(x -> this.handleEvent(changedEvent, x.getRightEntityClass(profile), (Relationship)x).stream()).collect(Collectors.toList());
        changeLogs.addAll(records);
        return null;
    }

    private List<Changelog> handleEvent(ChangedEvent changedEvent, IEntityClass entityClass, Relationship relationship) {
        if (entityClass.id() == changedEvent.getEntityClassId() && relationship == null) {
            return Collections.singletonList(this.genSourceChangelog(changedEvent));
        }
        List<Changelog> changelogs = this.relationAwareChangeLogs.stream().filter(x -> x.require(relationship)).flatMap(x -> x.generateOuterChangelog(relationship, entityClass, changedEvent).stream()).collect(Collectors.toList());
        return changelogs;
    }

    private Changelog genSourceChangelog(ChangedEvent changedEvent) {
        IEntity afterEntity = null;
        String comment = changedEvent.getComment();
        long timestamp = changedEvent.getTimestamp();
        long commitId = changedEvent.getCommitId();
        long entityClassId = changedEvent.getEntityClassId();
        Changelog changelog = new Changelog();
        switch (changedEvent.getOperationType()) {
            case CREATE: 
            case UPDATE: {
                List<ChangeValue> changeValues = this.toChangeValue(afterEntity);
                changelog.setcId((Long)this.idGenerator.next());
                changelog.setComment(comment);
                changelog.setCreateTime(timestamp);
                changelog.setEntityClass(entityClassId);
                changelog.setChangeValues(changeValues);
                changelog.setId(afterEntity.id());
                changelog.setVersion(commitId);
                break;
            }
            case DELETE: {
                changelog.setcId((Long)this.idGenerator.next());
                changelog.setComment(comment);
                changelog.setCreateTime(timestamp);
                changelog.setEntityClass(entityClassId);
                changelog.setChangeValues(Collections.emptyList());
                changelog.setId(afterEntity.id());
                changelog.setVersion(commitId);
                changelog.setDeleteFlag(1);
                break;
            }
            default: {
                changelog = null;
            }
        }
        return changelog;
    }

    @Override
    public void saveChangeLogs(List<Changelog> changeLogs) {
        this.changelogStorage.saveBatch(changeLogs);
    }

    @Override
    public List<ChangeVersion> getChangeLog(long objId, long entityClassId) {
        List<ChangeVersion> changeVersionList = Collections.emptyList();
        Stack<VersiondEntityRef> stack = new Stack<VersiondEntityRef>();
        stack.push(new VersiondEntityRef(entityClassId, objId));
        while (!stack.isEmpty()) {
            VersiondEntityRef nextNode = (VersiondEntityRef)stack.pop();
            changeVersionList = this.findChangeVersion(changeVersionList, nextNode.getId(), nextNode.getVersion(), nextNode.getEntityClassId(), stack);
        }
        return changeVersionList;
    }

    private List<ChangeVersion> findChangeVersion(List<ChangeVersion> changeVersionList, long objId, long version, long entityClassId, Stack<VersiondEntityRef> stack) {
        List<Changelog> relatedChangelog = this.replayService.getRelatedChangelog(objId, version, -1L);
        if (!relatedChangelog.isEmpty()) {
            List currentList = relatedChangelog.stream().map(x -> {
                ChangeVersion changeVersion = new ChangeVersion();
                changeVersion.setComment(x.getComment());
                changeVersion.setVersion(x.getVersion());
                return changeVersion;
            }).collect(Collectors.toList());
            changeVersionList = ChangelogHelper.mergeSortedList(changeVersionList, currentList, Comparator.comparingLong(ChangeVersion::getVersion));
            Optional entityClassOp = this.metaManager.load(entityClassId, "");
            if (entityClassOp.isPresent()) {
                IEntityClass entityClass = (IEntityClass)entityClassOp.get();
                EntityRelation mainRelation = this.replayService.replayRelation(entityClass, objId, relatedChangelog);
                mainRelation.getRelatedIds().forEach((key, value) -> {
                    long childEntity = key.getRightEntityClassId();
                    value.forEach(valueLife -> {
                        String idValue = valueLife.getValue();
                        if (idValue != null) {
                            try {
                                long idLong = Long.parseLong(idValue);
                                long endVersion = valueLife.getEnd();
                                stack.push(new VersiondEntityRef(childEntity, idLong, endVersion));
                            }
                            catch (Exception ex) {
                                this.logger.error("{}", (Throwable)ex);
                            }
                        } else {
                            this.logger.warn("REL on {} removed", (Object)key.getLeftEntityClassId());
                        }
                    });
                });
            }
        }
        return changeVersionList;
    }

    @Override
    public EntityAggDomain replayEntity(long entityClass, long objId, long version) {
        return this.replayService.replayAggDomain(entityClass, objId, version);
    }

    private List<ChangeValue> toChangeValue(IEntity entity) {
        IEntityValue entityValue = entity.entityValue();
        Collection values = entityValue.values();
        List<ChangeValue> changeValues = values.stream().map(x -> {
            ChangeValue changeValue = new ChangeValue();
            changeValue.setFieldId(x.getField().id());
            changeValue.setFieldCode(x.getField().name());
            changeValue.setOp(ChangeValue.Op.SET);
            changeValue.setRawValue(ChangelogHelper.serialize(x));
            return changeValue;
        }).collect(Collectors.toList());
        return changeValues;
    }
}

