/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.ultraman.oqsengine.changelog.ReplayService;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeSnapshot;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.Changelog;
import com.xforceplus.ultraman.oqsengine.changelog.domain.EntityAggDomain;
import com.xforceplus.ultraman.oqsengine.changelog.domain.EntityDomain;
import com.xforceplus.ultraman.oqsengine.changelog.domain.EntityRelation;
import com.xforceplus.ultraman.oqsengine.changelog.domain.HistoryValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ValueLife;
import com.xforceplus.ultraman.oqsengine.changelog.entity.ChangelogStatefulEntity;
import com.xforceplus.ultraman.oqsengine.changelog.storage.write.ChangelogStorage;
import com.xforceplus.ultraman.oqsengine.changelog.storage.write.SnapshotStorage;
import com.xforceplus.ultraman.oqsengine.changelog.utils.ChangelogHelper;
import com.xforceplus.ultraman.oqsengine.changelog.utils.EntityClassHelper;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Entity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayServiceImpl
implements ReplayService {
    private LoadingCache<Tuple2<Long, Long>, ChangelogStatefulEntity> cache = Caffeine.newBuilder().maximumSize(1000L).build(x -> this.replayStatefulEntityInternal((Long)x._1(), (Long)x._2()).orElse(null));
    private Logger logger = LoggerFactory.getLogger(ReplayService.class);
    @Resource
    private ChangelogStorage changelogStorage;
    @Resource
    private SnapshotStorage snapshotStorage;
    @Resource
    private MetaManager metaManager;
    private long snapshotThreshold = 100L;

    @Override
    public List<Changelog> getRelatedChangelog(long id) {
        return this.changelogStorage.findById(id, -1L, -1L);
    }

    @Override
    public List<Changelog> getRelatedChangelog(long id, long startVersion, long endVersion) {
        return this.changelogStorage.findById(id, startVersion, endVersion);
    }

    @Override
    public EntityDomain replaySimpleDomain(long entityClass, long id, long endVersion) {
        Tuple2<ChangeSnapshot, List<Changelog>> changeTuple = this.getChangeTuple(id, endVersion);
        Optional entityClassOp = this.metaManager.load(entityClass, "");
        return entityClassOp.map(iEntityClass -> this.replaySingleDomainWithSnapshot((IEntityClass)iEntityClass, id, (ChangeSnapshot)changeTuple._1(), (List)changeTuple._2())).orElse(null);
    }

    private Tuple2<ChangeSnapshot, List<Changelog>> getChangeTuple(long id, long endVersion) {
        Optional<ChangeSnapshot> snapshotOp = this.snapshotStorage.query(id, endVersion);
        long startVersion = -1L;
        if (snapshotOp.isPresent()) {
            ChangeSnapshot changeSnapshot = snapshotOp.get();
            startVersion = changeSnapshot.getVersion();
        }
        List<Changelog> relatedChangelogs = this.getRelatedChangelog(id, startVersion, endVersion);
        return Tuple.of((Object)snapshotOp.orElse(null), relatedChangelogs);
    }

    private void linkAllHistory(List<HistoryValue> historyValues) {
        historyValues.stream().reduce((a, b) -> {
            b.setNext((HistoryValue)a);
            a.setPreview((HistoryValue)b);
            return b;
        });
    }

    @Override
    public EntityRelation replayRelation(IEntityClass entityClass, long id, List<Changelog> changelogList) {
        EntityRelation entityRelation = new EntityRelation();
        entityRelation.setId(id);
        Map<Long, List<HistoryValue>> historyValueMapping = ChangelogHelper.getMappedHistoryValue(changelogList);
        HashMap<Relationship, Collection<ValueLife>> relationValues = new HashMap<Relationship, Collection<ValueLife>>();
        entityRelation.setRelatedIds(relationValues);
        HashMap valueMap = new HashMap();
        ((Collection)Optional.ofNullable(entityClass.relationship()).orElse(Collections.emptyList())).stream().filter(x -> x.isStrong() && !x.isCompanion()).forEach(x -> {
            List historyValues = (List)historyValueMapping.get(x.getEntityField().id());
            if (historyValues != null) {
                this.linkAllHistory(historyValues);
                historyValues.stream().sorted().forEach(historyValue -> {
                    ChangeValue value = historyValue.getValue();
                    Map valueLifeMap = valueMap.computeIfAbsent(x.getEntityField().id(), k -> new HashMap());
                    ValueLife valueLife = (ValueLife)valueLifeMap.get(value.getRawValue());
                    if (valueLife == null) {
                        valueLife = new ValueLife();
                        valueLife.setValue(value.getRawValue());
                        valueLifeMap.put(value.getRawValue(), valueLife);
                    }
                    switch (value.getOp()) {
                        case ADD: {
                            valueLife.setStart(historyValue.getCommitId());
                            valueLife.setEnd(-1L);
                            break;
                        }
                        case DEL: {
                            valueLife.setEnd(historyValue.getCommitId());
                            break;
                        }
                        case SET: {
                            ChangeValue previewChange;
                            String rawValue;
                            ValueLife previewValueLife;
                            valueLife.setStart(historyValue.getCommitId());
                            valueLife.setEnd(-1L);
                            if (historyValue.getPreview() == null || (previewValueLife = (ValueLife)valueLifeMap.get(rawValue = (previewChange = historyValue.getPreview().getValue()).getRawValue())) == null) break;
                            previewValueLife.setEnd(historyValue.getCommitId());
                            break;
                        }
                    }
                });
                relationValues.put((Relationship)x, ((Map)valueMap.get(x.getEntityField().id())).values());
            }
        });
        return entityRelation;
    }

    @Override
    public EntityAggDomain replayAggDomain(long entityClass, long id, long version) {
        LinkedList<Tuple3> taskQueue = new LinkedList<Tuple3>();
        HashMap<Long, EntityDomain> footprint = new HashMap<Long, EntityDomain>();
        taskQueue.offer(Tuple.of((Object)entityClass, (Object)id, (Object)version));
        while (!taskQueue.isEmpty()) {
            Tuple3 task = (Tuple3)taskQueue.poll();
            Optional entityClassOptional = this.metaManager.load(((Long)task._1).longValue(), "");
            if (!entityClassOptional.isPresent()) continue;
            Tuple2<ChangeSnapshot, List<Changelog>> changelogTuple = this.getChangeTuple(id, version);
            EntityDomain entityDomain = this.replaySingleDomainWithSnapshot((IEntityClass)entityClassOptional.get(), (Long)task._2, (ChangeSnapshot)changelogTuple._1(), (List)changelogTuple._2());
            footprint.put((Long)task._2, entityDomain);
            entityDomain.getReferenceMap().forEach((key, value) -> value.forEach(eachId -> taskQueue.offer(Tuple.of((Object)key.getRightEntityClassId(), (Object)eachId, (Object)version))));
        }
        EntityAggDomain head = new EntityAggDomain();
        this.buildAggDomain(id, footprint, head);
        return head;
    }

    private Optional<ChangelogStatefulEntity> replayStatefulEntityInternal(long entityClassId, long id) {
        Optional loadEntityClassOp = this.metaManager.load(entityClassId, "");
        return loadEntityClassOp.map(x -> {
            EntityDomain entityDomain = this.replaySimpleDomain(entityClassId, id, -1L);
            ChangelogStatefulEntity statefulEntity = new ChangelogStatefulEntity(id, (IEntityClass)x, this.metaManager, entityDomain, this.snapshotThreshold);
            return statefulEntity;
        });
    }

    @Override
    public Optional<ChangelogStatefulEntity> replayStatefulEntity(long entityClassId, long id) {
        return Optional.ofNullable((ChangelogStatefulEntity)this.cache.get((Object)Tuple.of((Object)entityClassId, (Object)id)));
    }

    private void buildAggDomain(long id, Map<Long, EntityDomain> map, EntityAggDomain head) {
        LinkedList<Tuple3> taskIdQueue = new LinkedList<Tuple3>();
        taskIdQueue.offer(Tuple.of((Object)id, (Object)head, null));
        while (!taskIdQueue.isEmpty()) {
            Tuple3 task = (Tuple3)taskIdQueue.poll();
            Long currentNodeId = (Long)task._1;
            EntityAggDomain currentEntityAgg = (EntityAggDomain)task._2;
            Tuple2 previewEntityRelToAgg = (Tuple2)task._3;
            EntityDomain entityDomain = map.get(currentNodeId);
            if (entityDomain == null) continue;
            currentEntityAgg.setRootIEntity(entityDomain.getEntity());
            if (previewEntityRelToAgg != null) {
                ((EntityAggDomain)previewEntityRelToAgg._2()).put((Relationship)previewEntityRelToAgg._1(), currentEntityAgg);
            }
            entityDomain.getReferenceMap().forEach((key, value) -> value.forEach(refId -> {
                EntityAggDomain entityAggDomain = new EntityAggDomain();
                taskIdQueue.offer(Tuple.of((Object)refId, (Object)entityAggDomain, (Object)Tuple.of((Object)key, (Object)currentEntityAgg)));
            }));
        }
    }

    private IValue getValue(List<ChangeValue> changeValues, IEntityField field) {
        Optional<ChangeValue> firstSet = changeValues.stream().filter(x -> x.getOp() == ChangeValue.Op.SET).findFirst();
        if (firstSet.isPresent()) {
            ChangeValue changeValue = firstSet.get();
            String rawValue = changeValue.getRawValue();
            IValue value = ChangelogHelper.deserialize(rawValue, field);
            return value;
        }
        return null;
    }

    private EntityDomain replaySingleDomainWithSnapshot(IEntityClass entityClass, long id, ChangeSnapshot changeSnapshot, List<Changelog> changelogs) {
        Entity entity = Entity.Builder.anEntity().withId(id).withEntityClassRef(EntityClassRef.Builder.anEntityClassRef().withEntityClassId(entityClass.id()).build()).build();
        HashMap<Relationship, List<Long>> referenceMap = new HashMap<Relationship, List<Long>>();
        EntityDomain entityDomain = !changelogs.isEmpty() ? new EntityDomain(changelogs.size(), changelogs.get(0).getVersion(), (IEntity)entity, referenceMap) : new EntityDomain(changelogs.size(), 0L, (IEntity)entity, referenceMap);
        Map<Object, Object> mappedValue = new HashMap();
        if (changeSnapshot != null) {
            changeSnapshot.getReferenceMap().forEach((k, v) -> {
                Optional<Relationship> relationWithFieldId = EntityClassHelper.findRelationWithFieldId(entityClass, k);
                relationWithFieldId.ifPresent(x -> referenceMap.put((Relationship)x, (List<Long>)v));
            });
            mappedValue = changeSnapshot.getChangeValues().stream().collect(Collectors.toMap(ChangeValue::getFieldId, x -> {
                LinkedList<ChangeValue> changeValues = new LinkedList<ChangeValue>();
                changeValues.add((ChangeValue)x);
                return changeValues;
            }));
        }
        HashMap finalMappedValue = mappedValue;
        Map<Long, List<ChangeValue>> mappedValueFromChangelogs = ChangelogHelper.getMappedValue(changelogs);
        mappedValueFromChangelogs.forEach((a, b) -> {
            if (finalMappedValue.containsKey(a)) {
                List changeValues = (List)finalMappedValue.get(a);
                if (changeValues != null) {
                    changeValues.addAll(b);
                } else {
                    finalMappedValue.put(a, b);
                }
            } else {
                finalMappedValue.put(a, b);
            }
        });
        IEntityValue entityValue = entity.entityValue();
        entityClass.fields().forEach(field -> {
            List changeValues = (List)finalMappedValue.get(field.id());
            IValue value = null;
            if (changeValues != null) {
                value = this.getValue(changeValues, (IEntityField)field);
            }
            if (value != null) {
                entityValue.addValue(value);
            }
        });
        ((Collection)Optional.ofNullable(entityClass.relationship()).orElse(Collections.emptyList())).forEach(rel -> {
            List changeValues = Optional.ofNullable((List)finalMappedValue.get(rel.getEntityField().id())).orElseGet(Collections::emptyList);
            if (ChangelogHelper.isReferenceSetInCurrentView(rel, entityClass.id())) {
                LinkedList ids = new LinkedList();
                changeValues.forEach(changeValue -> {
                    switch (changeValue.getOp()) {
                        case ADD: {
                            ids.add(Long.parseLong(changeValue.getRawValue()));
                            break;
                        }
                        case DEL: {
                            ids.remove(Long.parseLong(changeValue.getRawValue()));
                            break;
                        }
                        default: {
                            this.logger.warn("unsupport operation for referenceset");
                        }
                    }
                });
                if (!ids.isEmpty()) {
                    referenceMap.put((Relationship)rel, ids);
                }
            } else {
                IValue value = this.getValue(changeValues, rel.getEntityField());
                if (value != null) {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    ids.add(value.valueToLong());
                    referenceMap.put((Relationship)rel, (List<Long>)ids);
                }
            }
        });
        return entityDomain;
    }
}

