/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.listener.flow;

import akka.stream.ActorMaterializer;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.xforceplus.ultraman.oqsengine.changelog.listener.flow.QueueFlow;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowRegistry {
    private ActorMaterializer mat;
    private Logger logger = LoggerFactory.getLogger(FlowRegistry.class);
    private Integer timeoutMili;
    LoadingCache<String, QueueFlow> cache;
    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public FlowRegistry(ActorMaterializer mat, Integer mili) {
        this.mat = mat;
        this.timeoutMili = mili;
        this.cache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess((long)this.timeoutMili.intValue(), TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, QueueFlow>(){

            public void onRemoval(@Nullable String s, @Nullable QueueFlow queueFlow, @NonNull RemovalCause removalCause) {
                FlowRegistry.this.logger.info("Flow for {} is over due to time expiry", (Object)s);
                if (queueFlow != null) {
                    queueFlow.close();
                }
            }
        }).build(key -> {
            this.logger.info("Flow for {} is setup", key);
            return new QueueFlow((String)key, mat);
        });
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.cache.cleanUp(), 2L, 10L, TimeUnit.SECONDS);
    }

    public <T> QueueFlow<T> flow(String name) {
        return (QueueFlow)this.cache.get((Object)name);
    }
}

