/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.relation;

import com.xforceplus.ultraman.oqsengine.changelog.ReplayService;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangedEvent;
import com.xforceplus.ultraman.oqsengine.changelog.domain.Changelog;
import com.xforceplus.ultraman.oqsengine.changelog.domain.EntityRelation;
import com.xforceplus.ultraman.oqsengine.changelog.relation.RelationAwareChangelog;
import com.xforceplus.ultraman.oqsengine.common.id.IdGenerator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManyToOneRelationChangelog
implements RelationAwareChangelog {
    private Logger logger = LoggerFactory.getLogger(ManyToOneRelationChangelog.class);
    @Resource(name="longNoContinuousPartialOrderIdGenerator")
    private IdGenerator<Long> idGenerator;
    @Resource
    private ReplayService replayService;

    @Override
    public boolean require(Relationship relation) {
        return relation.getRelationType() == Relationship.RelationType.MANY_TO_ONE;
    }

    private Changelog changelogForOuter(long entityClassId, Long objId, long fieldId, long relatedObjId, long commitId, long timestamp, String comment, ChangeValue.Op op) {
        Changelog changelog = new Changelog();
        changelog.setcId((Long)this.idGenerator.next());
        changelog.setEntityClass(entityClassId);
        changelog.setCreateTime(timestamp);
        changelog.setId(relatedObjId);
        changelog.setVersion(commitId);
        changelog.setComment(comment);
        ChangeValue changeValue = new ChangeValue();
        changeValue.setReferenceSet(true);
        changeValue.setFieldId(fieldId);
        changeValue.setOp(op);
        changeValue.setRawValue(objId.toString());
        changelog.setChangeValues(Collections.singletonList(changeValue));
        return changelog;
    }

    private boolean noChanges(Relationship relation, ChangedEvent changedEvent) {
        long changedEntityClass = changedEvent.getEntityClassId();
        return relation.getRightEntityClassId() != changedEntityClass;
    }

    @Override
    public List<Changelog> generateOuterChangelog(Relationship relation, IEntityClass entityClass, ChangedEvent changedEvent) {
        long relatedObjIdBefore;
        Optional<Changelog> changelog;
        long fieldId;
        if (this.noChanges(relation, changedEvent)) {
            return Collections.singletonList(this.noChangesChangelog((Long)this.idGenerator.next(), changedEvent));
        }
        Object beforeChange = null;
        Object afterChange = null;
        long commitId = changedEvent.getCommitId();
        long timestamp = changedEvent.getTimestamp();
        String comment = changedEvent.getComment();
        long id = changedEvent.getId();
        long companionFieldId = fieldId = relation.getEntityField().id();
        if (relation.isCompanion()) {
            companionFieldId = relation.getCompanionRelation();
        }
        Optional beforeOuter = Optional.ofNullable(beforeChange).flatMap(change -> change.entityValue().values().stream().filter(x -> x.getField().id() == fieldId).findFirst());
        Optional afterOuter = Optional.ofNullable(afterChange).flatMap(change -> change.entityValue().values().stream().filter(x -> x.getField().id() == fieldId).findFirst());
        boolean before = beforeOuter.isPresent();
        boolean after = afterOuter.isPresent();
        if (!before && after) {
            long relatedObjIdAfter = ((IValue)afterOuter.get()).valueToLong();
            Optional<Changelog> changelog2 = this.genChangelogForRelatedEntity(relatedObjIdAfter, entityClass, id, companionFieldId, ChangeValue.Op.ADD, commitId, timestamp, comment);
            if (changelog2.isPresent()) {
                return Collections.singletonList(changelog2.get());
            }
        } else if (before && after) {
            if (!((IValue)afterOuter.get()).getValue().equals(((IValue)beforeOuter.get()).getValue())) {
                LinkedList<Changelog> changelogs = new LinkedList<Changelog>();
                long relatedObjIdAfter = ((IValue)afterOuter.get()).valueToLong();
                this.genChangelogForRelatedEntity(relatedObjIdAfter, entityClass, id, companionFieldId, ChangeValue.Op.ADD, commitId, timestamp, comment).ifPresent(changelogs::add);
                long relatedObjIdBefore2 = ((IValue)beforeOuter.get()).valueToLong();
                this.genChangelogForRelatedEntity(relatedObjIdBefore2, entityClass, id, companionFieldId, ChangeValue.Op.DEL, commitId, timestamp, comment).ifPresent(changelogs::add);
                return changelogs;
            }
        } else if (before && !after && (changelog = this.genChangelogForRelatedEntity(relatedObjIdBefore = ((IValue)beforeOuter.get()).valueToLong(), entityClass, id, companionFieldId, ChangeValue.Op.DEL, commitId, timestamp, comment)).isPresent()) {
            return Collections.singletonList(changelog.get());
        }
        return Collections.emptyList();
    }

    private Optional<Changelog> genChangelogForRelatedEntity(long relatedObjId, IEntityClass relatedEntityClass, long selfId, long fieldId, ChangeValue.Op op, long commitId, long timestamp, String comment) {
        Optional<EntityRelation> entityRelation = this.findEntityByOuterKey(relatedEntityClass, relatedObjId);
        if (entityRelation.isPresent()) {
            Changelog changelog = this.changelogForOuter(relatedEntityClass.id(), selfId, fieldId, relatedObjId, commitId, timestamp, comment, op);
            return Optional.ofNullable(changelog);
        }
        return Optional.empty();
    }

    Optional<EntityRelation> findEntityByOuterKey(IEntityClass entityClass, long id) {
        List<Changelog> relatedChangelogList = this.replayService.getRelatedChangelog(id);
        if (relatedChangelogList.isEmpty()) {
            return Optional.empty();
        }
        EntityRelation entityRelation = this.replayService.replayRelation(entityClass, id, relatedChangelogList);
        return Optional.ofNullable(entityRelation);
    }
}

