/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.storage.query.impl;

import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeVersion;
import com.xforceplus.ultraman.oqsengine.changelog.storage.query.QueryStorage;
import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLQueryStorage
implements QueryStorage {
    final Logger logger = LoggerFactory.getLogger(SQLQueryStorage.class);
    @Resource(name="changelogDataSource")
    private DataSource changelogQueryDataSource;
    @Resource(name="longNoContinuousPartialOrderIdGenerator")
    private LongIdGenerator snowFlakeIdGenerator;
    private String tableName = "changeversion";

    @Override
    public Map<Long, Long> changeCountMapping(List<Long> ids, boolean isSelf) throws SQLException {
        Connection connection = this.changelogQueryDataSource.getConnection();
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(ids.size());
        ids.forEach(x -> retMap.put((Long)x, 0L));
        String idsStr = ids.stream().map(Object::toString).collect(Collectors.joining(","));
        String sql = isSelf ? String.format("select id, count(*) as count from %s where id in (%s) and source = id group by id", this.tableName, idsStr) : String.format("select id, count(*) as count from %s where id in (%s) group by id", this.tableName, idsStr);
        try (PreparedStatement st = connection.prepareStatement(sql);
             ResultSet resultSet = st.executeQuery();){
            while (resultSet.next()) {
                long id = resultSet.getLong("id");
                long count = resultSet.getLong("count");
                retMap.put(id, count);
            }
        }
        return retMap;
    }

    @Override
    public List<ChangeVersion> queryChangelog(long id, boolean isSelf, int page, int size) throws SQLException {
        Connection connection = this.changelogQueryDataSource.getConnection();
        LinkedList<ChangeVersion> changeVersionList = new LinkedList<ChangeVersion>();
        if (page < 1) {
            page = 1;
        }
        String sql = isSelf ? String.format("select * from %s where id = %s and source = id order by version desc limit %s, %s", this.tableName, id, (page - 1) * size, size) : String.format("select * from %s where id = %s order by version desc limit %s, %s", this.tableName, id, (page - 1) * size, size);
        try (PreparedStatement st = connection.prepareStatement(sql);
             ResultSet resultSet = st.executeQuery();){
            while (resultSet.next()) {
                ChangeVersion cv = new ChangeVersion();
                cv.setTimestamp(resultSet.getLong("timestamp"));
                cv.setComment(resultSet.getString("comment"));
                cv.setUsername(resultSet.getString("user"));
                cv.setVersion(resultSet.getLong("version"));
                cv.setSource(resultSet.getLong("source"));
                changeVersionList.add(cv);
            }
        }
        return changeVersionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveChangeVersion(long id, List<ChangeVersion> changeVersionList) throws SQLException {
        String sql = String.format("insert into %s (vid, id, comment, version, timestamp, user, source)values (?, ? , ?, ?, ?, ?, ?)", this.tableName);
        try (Connection connection = this.changelogQueryDataSource.getConnection();){
            changeVersionList.forEach(x -> {
                try {
                    this.save(connection, sql, (ChangeVersion)x);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        }
        return 1;
    }

    private int save(Connection connection, String sql, ChangeVersion changeVersion) throws SQLException {
        try (PreparedStatement st = connection.prepareStatement(sql);){
            st.setLong(1, (Long)this.snowFlakeIdGenerator.next());
            st.setLong(2, changeVersion.getId());
            st.setString(3, changeVersion.getComment());
            st.setLong(4, changeVersion.getVersion());
            st.setLong(5, changeVersion.getTimestamp());
            st.setString(6, changeVersion.getUsername());
            st.setLong(7, changeVersion.getSource());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(st.toString());
            }
            int n = st.executeUpdate();
            return n;
        }
    }
}

