/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.storage.write.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.Changelog;
import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogStorageCommand {
    final Logger logger = LoggerFactory.getLogger(ChangelogStorageCommand.class);
    final ObjectMapper mapper;
    private String tableName;

    public ChangelogStorageCommand(String tableName, ObjectMapper mapper) {
        this.tableName = tableName;
        this.mapper = mapper;
    }

    public List<Changelog> findChangelogById(DataSource dataSource, long id, long startVersion, long endVersion) throws SQLException {
        String sql = startVersion < 0L ? String.format("select * from %s where id = %s and version <= %s order by version desc", this.tableName, id, endVersion) : String.format("select * from %s where id = %s and (version >= %s and version <= %s) order by version desc", this.tableName, id, startVersion, endVersion);
        LinkedList<Changelog> retList = new LinkedList<Changelog>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement st = connection.prepareStatement(sql);
             ResultSet resultSet = st.executeQuery();){
            while (resultSet.next()) {
                long cid = resultSet.getLong("cid");
                long recordId = resultSet.getLong("id");
                String comment = resultSet.getString("comment");
                long createTime = resultSet.getLong("create_time");
                String json = resultSet.getString("changes");
                long entity = resultSet.getLong("entity");
                long version = resultSet.getLong("version");
                Changelog changelog = new Changelog();
                changelog.setcId(cid);
                changelog.setId(recordId);
                changelog.setComment(comment);
                changelog.setCreateTime(createTime);
                changelog.setVersion(version);
                changelog.setEntityClass(entity);
                List changeValues = Collections.emptyList();
                try {
                    changeValues = (List)this.mapper.readValue(json, (TypeReference)new TypeReference<List<ChangeValue>>(){});
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                changelog.setChangeValues(changeValues);
                retList.add(changelog);
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveChangelog(DataSource dataSource, LongIdGenerator longIdGenerator, List<Changelog> changelogList) throws SQLException {
        String sql = String.format("insert into %s (cid, id, entity, comment, changes, version, create_time)values ( ?, ?, ?, ?, ?, ?, ?)", this.tableName);
        try (Connection connection = dataSource.getConnection();){
            changelogList.forEach(x -> {
                try {
                    this.save(connection, longIdGenerator, sql, (Changelog)x);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        }
        return 1;
    }

    private int save(Connection connection, LongIdGenerator longIdGenerator, String sql, Changelog changelog) throws SQLException {
        int n;
        block9: {
            PreparedStatement st = connection.prepareStatement(sql);
            try {
                st.setLong(1, (Long)longIdGenerator.next());
                st.setLong(2, changelog.getId());
                st.setLong(3, changelog.getEntityClass());
                st.setString(4, changelog.getComment());
                st.setString(5, this.mapper.writeValueAsString(changelog.getChangeValues()));
                st.setLong(6, changelog.getVersion());
                st.setLong(7, changelog.getCreateTime());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(st.toString());
                }
                n = st.executeUpdate();
                if (st == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            st.close();
        }
        return n;
    }
}

