/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.storage.write.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.changelog.domain.Changelog;
import com.xforceplus.ultraman.oqsengine.changelog.storage.write.ChangelogStorage;
import com.xforceplus.ultraman.oqsengine.changelog.storage.write.impl.ChangelogStorageCommand;
import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import io.vavr.control.Either;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLChangelogStorage
implements ChangelogStorage {
    @Resource(name="changelogDataSource")
    private DataSource changelogDatasource;
    @Resource(name="longNoContinuousPartialOrderIdGenerator")
    private LongIdGenerator idGenerator;
    @Resource
    private ObjectMapper mapper;
    private String table = "changelog";
    Logger logger = LoggerFactory.getLogger(SQLChangelogStorage.class);

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Either<SQLException, Integer> saveBatch(List<Changelog> changeLogs) {
        try {
            int result = new ChangelogStorageCommand(this.table, this.mapper).saveChangelog(this.changelogDatasource, this.idGenerator, changeLogs);
            return Either.right((Object)result);
        }
        catch (SQLException e) {
            this.logger.error("{}", (Throwable)e);
            return Either.left((Object)e);
        }
    }

    @Override
    public List<Changelog> findById(long id, long startVersion, long endVersion) {
        try {
            List<Changelog> result = new ChangelogStorageCommand(this.table, this.mapper).findChangelogById(this.changelogDatasource, id, startVersion, endVersion);
            return result;
        }
        catch (SQLException e) {
            this.logger.error("{}", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

