/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.storage.write.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeSnapshot;
import com.xforceplus.ultraman.oqsengine.changelog.storage.write.SnapshotStorage;
import com.xforceplus.ultraman.oqsengine.changelog.storage.write.impl.SnapshotStorageCommand;
import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import io.vavr.control.Either;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Resource;
import javax.sql.DataSource;

public class SQLSnapshotStorage
implements SnapshotStorage {
    @Resource(name="changelogDataSource")
    private DataSource changelogDatasource;
    @Resource(name="longNoContinuousPartialOrderIdGenerator")
    private LongIdGenerator idGenerator;
    @Resource
    private ObjectMapper mapper;
    private String tableName = "changelogsnapshot";

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public Either<SQLException, Integer> saveSnapshot(ChangeSnapshot changeSnapshot) {
        try {
            int result = new SnapshotStorageCommand(this.tableName, this.mapper).saveSnapshot(this.changelogDatasource, this.idGenerator, changeSnapshot);
            return Either.right((Object)result);
        }
        catch (SQLException e) {
            return Either.left((Object)e);
        }
    }

    @Override
    public Optional<ChangeSnapshot> query(long objId, long version) {
        try {
            return Optional.of(new SnapshotStorageCommand(this.tableName, this.mapper).querySnapshot(this.changelogDatasource, objId, version));
        }
        catch (SQLException ex) {
            return Optional.empty();
        }
    }
}

