/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.storage.write.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeSnapshot;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeValue;
import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotStorageCommand {
    final Logger logger = LoggerFactory.getLogger(SnapshotStorageCommand.class);
    final ObjectMapper mapper;
    private String tableName;

    public SnapshotStorageCommand(String tableName, ObjectMapper mapper) {
        this.tableName = tableName;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSnapshot querySnapshot(DataSource dataSource, long objId, long version) throws SQLException {
        String sql = version < 0L ? String.format("select * from %s where id = %s order by version desc limit 1", this.tableName, objId) : String.format("select * from %s where id = %s where version <= %s order by version desc limit 1", this.tableName, objId, version);
        try (Connection connection = dataSource.getConnection();){
            ChangeSnapshot changeSnapshot = this.findSnapshot(connection, sql);
            return changeSnapshot;
        }
    }

    private ChangeSnapshot findSnapshot(Connection connection, String sql) throws SQLException {
        try (PreparedStatement st = connection.prepareStatement(sql);){
            ChangeSnapshot changeSnapshot;
            block18: {
                ResultSet resultSet;
                block16: {
                    ChangeSnapshot changeSnapshot2;
                    block17: {
                        resultSet = st.executeQuery();
                        try {
                            if (!resultSet.next()) break block16;
                            long sid = resultSet.getLong("sid");
                            long recordId = resultSet.getLong("id");
                            long createTime = resultSet.getLong("create_time");
                            String json = resultSet.getString("changes");
                            String referenceMapJson = resultSet.getString("reference");
                            long entity = resultSet.getLong("entity");
                            long recordVersion = resultSet.getLong("version");
                            ChangeSnapshot changeSnapshot3 = new ChangeSnapshot();
                            changeSnapshot3.setsId(sid);
                            changeSnapshot3.setId(recordId);
                            changeSnapshot3.setEntityClass(entity);
                            changeSnapshot3.setCreateTime(createTime);
                            changeSnapshot3.setVersion(recordVersion);
                            List changeValues = Collections.emptyList();
                            Map referenceMap = Collections.emptyMap();
                            try {
                                changeValues = (List)this.mapper.readValue(json, (TypeReference)new TypeReference<List<ChangeValue>>(){});
                                referenceMap = (Map)this.mapper.readValue(referenceMapJson, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){});
                            }
                            catch (JsonProcessingException e) {
                                e.printStackTrace();
                            }
                            changeSnapshot3.setChangeValues(changeValues);
                            changeSnapshot3.setReferenceMap(referenceMap);
                            changeSnapshot2 = changeSnapshot3;
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return changeSnapshot2;
                }
                changeSnapshot = null;
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return changeSnapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveSnapshot(DataSource dataSource, LongIdGenerator longIdGenerator, ChangeSnapshot changeSnapshot) throws SQLException {
        String sql = String.format("insert into %s (sid, id, entity, changes, reference, version, create_time)values ( ?, ? , ? , ? , ?, ?, ?)", this.tableName);
        try (Connection connection = dataSource.getConnection();){
            this.save(connection, sql, longIdGenerator, changeSnapshot);
        }
        return 1;
    }

    private int save(Connection connection, String sql, LongIdGenerator longIdGenerator, ChangeSnapshot changeSnapshot) throws SQLException {
        try (PreparedStatement st = connection.prepareStatement(sql);){
            st.setLong(1, (Long)longIdGenerator.next());
            st.setLong(2, changeSnapshot.getId());
            st.setLong(3, changeSnapshot.getEntityClass());
            st.setString(4, this.mapper.writeValueAsString(changeSnapshot.getChangeValues()));
            st.setString(5, this.mapper.writeValueAsString(changeSnapshot.getReferenceMap()));
            st.setLong(6, changeSnapshot.getVersion());
            st.setLong(7, changeSnapshot.getCreateTime());
        }
        catch (JsonProcessingException e) {
            this.logger.error("{}", (Throwable)e);
            return -1;
        }
        return 1;
    }
}

