/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.utils;

import com.xforceplus.ultraman.oqsengine.changelog.domain.ChangeValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.Changelog;
import com.xforceplus.ultraman.oqsengine.changelog.domain.HistoryValue;
import com.xforceplus.ultraman.oqsengine.changelog.domain.ValueWrapper;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChangelogHelper {
    public static Map<Long, List<ChangeValue>> getMappedValue(List<Changelog> changelogList) {
        Map<Long, List<ChangeValue>> valueMapping = changelogList.stream().flatMap(x -> x.getChangeValues().stream()).collect(Collectors.groupingBy(ChangeValue::getFieldId));
        return valueMapping;
    }

    public static Map<Long, List<HistoryValue>> getMappedHistoryValue(List<Changelog> changelogList) {
        Map<Long, List<HistoryValue>> history = changelogList.stream().flatMap(x -> x.getChangeValues().stream().map(cv -> {
            HistoryValue historyValue = new HistoryValue();
            historyValue.setFieldId(cv.getFieldId());
            historyValue.setCommitId(x.getVersion());
            historyValue.setValue((ChangeValue)cv);
            return historyValue;
        })).collect(Collectors.groupingBy(HistoryValue::getFieldId));
        return history;
    }

    public static boolean isReferenceSetInCurrentView(Relationship relation, Long entityClassId) {
        if (relation.getRelationType() == Relationship.RelationType.MANY_TO_ONE) {
            return !relation.isBelongToOwner();
        }
        if (relation.getRelationType() == Relationship.RelationType.ONE_TO_MANY) {
            return !relation.isBelongToOwner();
        }
        return false;
    }

    public static String serialize(ValueWrapper valueWrapper) {
        return ChangelogHelper.serialize(valueWrapper.getIValue());
    }

    public static String serialize(IValue value) {
        return IValueUtils.serialize((IValue)value);
    }

    public static IValue deserialize(String rawValue, IEntityField entityField) {
        return IValueUtils.deserialize((String)rawValue, (IEntityField)entityField);
    }

    public static <T> List<T> mergeSortedList(List<T> listA, List<T> listB, Comparator<T> comparator) {
        LinkedList<T> mergedList = new LinkedList<T>();
        int i = 0;
        int j = 0;
        while (i < listA.size() && j < listB.size()) {
            T tb;
            T ta = listA.get(i);
            if (comparator.compare(ta, tb = listB.get(j)) >= 0) {
                mergedList.add(ta);
                ++i;
                continue;
            }
            mergedList.add(tb);
            ++j;
        }
        if (i < listA.size()) {
            mergedList.addAll(listA.subList(i, listA.size() - 1));
        }
        if (j < listB.size()) {
            mergedList.addAll(listB.subList(j, listB.size() - 1));
        }
        return mergedList;
    }
}

