/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.changelog.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class EntityClassHelper {
    private static final String MTO = "MTO";

    public static List<Relationship> findPropagationRelation(IEntityClass entityClass) {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        entityClass.relationship().forEach(oqsRelation -> {
            if (!EntityClassHelper.isRelationOwner(entityClass.id(), oqsRelation) && oqsRelation.isStrong()) {
                relationships.add((Relationship)oqsRelation);
            }
        });
        return relationships;
    }

    public static List<Relationship> findNextRelation(IEntityClass entityClass) {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        entityClass.relationship().forEach(oqsRelation -> {
            if (EntityClassHelper.isRelationOwner(entityClass.id(), oqsRelation)) {
                relationships.add((Relationship)oqsRelation);
            }
        });
        return relationships;
    }

    public static Long findIdAssociatedEntityClassId(Relationship relationship) {
        if (relationship.getRelationType() == Relationship.RelationType.MANY_TO_ONE || relationship.getRelationType() == Relationship.RelationType.ONE_TO_ONE) {
            return relationship.getRightEntityClassId();
        }
        return relationship.getLeftEntityClassId();
    }

    public static Optional<Relationship> findRelationWithFieldId(IEntityClass entityClass, long fieldId) {
        return entityClass.relationship().stream().filter(x -> x.getEntityField().id() == fieldId).findFirst();
    }

    public static List<Tuple2<Relationship, Relationship>> findAssociatedRelations(IEntityClass entityClass) {
        LinkedList<Tuple2<Relationship, Relationship>> oqsRelations = new LinkedList<Tuple2<Relationship, Relationship>>();
        HashMap temp = new HashMap();
        entityClass.relationship().forEach(oqsRelation -> {
            Relationship retRelationship;
            String relName = oqsRelation.getCode();
            if (relName.endsWith(MTO)) {
                relName = relName.substring(0, relName.length() - MTO.length());
            }
            if ((retRelationship = temp.putIfAbsent(relName, oqsRelation)) != null) {
                if (retRelationship.getRelationType() == Relationship.RelationType.MANY_TO_ONE && EntityClassHelper.isRelationOwner(entityClass.id(), retRelationship)) {
                    oqsRelations.add(Tuple.of((Object)oqsRelation, (Object)retRelationship));
                } else if (retRelationship.getRelationType() == Relationship.RelationType.MANY_TO_ONE && EntityClassHelper.isRelationOwner(entityClass.id(), oqsRelation)) {
                    oqsRelations.add(Tuple.of((Object)retRelationship, (Object)oqsRelation));
                }
            } else {
                temp.put(relName, oqsRelation);
            }
        });
        return oqsRelations;
    }

    private static boolean isRelationOwner(long id, Relationship relation) {
        return id == relation.getLeftEntityClassId();
    }
}

