/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.timerwheel;

import com.xforceplus.ultraman.oqsengine.common.pool.ExecutorHelper;
import com.xforceplus.ultraman.oqsengine.common.timerwheel.TimeoutNotification;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimerWheel<T> {
    private static final int DEFAULT_SLOT_NUMBER = 512;
    private static final int DEFAULT_DURATION = 100;
    private final Lock lock = new ReentrantLock();
    private final TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private final long duration;
    private final TimeoutNotification<T> notification;
    private final int slotNumber;
    private final List<Slot> wheel;
    private final ExecutorService worker;
    private int currentSlot;
    private final Map<T, Integer> removeHelp;

    public TimerWheel() {
        this(-1, -1L, null);
    }

    public TimerWheel(TimeoutNotification<T> notification) {
        this(-1, -1L, notification);
    }

    public TimerWheel(int slotNumber, long duration) {
        this(slotNumber, duration, null);
    }

    public TimerWheel(int slotNumber, long duration, TimeoutNotification<T> notification) {
        this.duration = duration <= 0L ? 100L : duration;
        this.slotNumber = slotNumber <= 3 ? 512 : slotNumber;
        this.notification = notification == null ? t -> 0L : notification;
        this.currentSlot = 0;
        this.wheel = new ArrayList<Slot>(this.slotNumber);
        for (int i = 0; i < this.slotNumber; ++i) {
            this.wheel.add(new Slot());
        }
        this.removeHelp = new HashMap<T, Integer>(16);
        this.worker = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), ExecutorHelper.buildNameThreadFactory("time-wheel", true));
        this.worker.submit(new PointTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T target, long timeout) {
        if (target == null) {
            throw new NullPointerException("Target object is null!");
        }
        if (timeout <= 0L) {
            return;
        }
        long specialTimeout = timeout;
        if (specialTimeout < this.duration) {
            specialTimeout = this.duration;
        }
        this.lock.lock();
        try {
            int virtualSlotIndex = this.calculateVirtualSlot(specialTimeout);
            int actuallySlotIndex = this.calculateActuallySlot(virtualSlotIndex);
            int round = this.calculateRuound(virtualSlotIndex);
            Slot slot = this.wheel.get(actuallySlotIndex);
            slot.add(target, round);
            this.removeHelp.put(target, actuallySlotIndex);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(T target, Date expireDate) {
        this.add(target, expireDate.getTime() - System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T target) {
        if (target == null) {
            return;
        }
        this.lock.lock();
        try {
            Integer slotIndex = this.removeHelp.remove(target);
            if (slotIndex != null) {
                Slot slot = this.wheel.get(slotIndex);
                slot.remove(target);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.removeHelp.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int calculateRuound(int virtualSlot) {
        return virtualSlot / this.slotNumber;
    }

    private int calculateActuallySlot(int virtualSlot) {
        return virtualSlot % this.slotNumber;
    }

    private int calculateVirtualSlot(long timeout) {
        return (int)((long)this.currentSlot + timeout / this.duration);
    }

    private class PointTask
    implements Runnable {
        private PointTask() {
        }

        @Override
        public void run() {
            do {
                List expireList;
                TimerWheel.this.lock.lock();
                try {
                    Slot slot = (Slot)TimerWheel.this.wheel.get(TimerWheel.this.currentSlot);
                    expireList = slot.expire();
                    TimerWheel.this.currentSlot = (TimerWheel.this.currentSlot + 1) % TimerWheel.this.slotNumber;
                }
                finally {
                    TimerWheel.this.lock.unlock();
                }
                try {
                    for (Object target : expireList) {
                        long resultTime = TimerWheel.this.notification.notice(target);
                        if (resultTime <= 0L) continue;
                        TimerWheel.this.add(target, resultTime);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                }
                try {
                    TimerWheel.this.timeUnit.sleep(TimerWheel.this.duration);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            } while (!Thread.interrupted());
        }
    }

    private class Element {
        private final T target;
        private int round;

        public Element(T target, int round) {
            this.target = target;
            this.round = round;
        }

        public T getTarget() {
            return this.target;
        }

        public int reduceRound() {
            return this.round--;
        }

        public int getRound() {
            return this.round;
        }

        public String toString() {
            return "Element{target=" + this.target + ", round=" + this.round + '}';
        }
    }

    private class Slot {
        private final List<Element> elements = new LinkedList<Element>();

        private Slot() {
        }

        public void add(T obj, int round) {
            Element element = new Element(obj, round);
            this.elements.add(element);
        }

        public List<T> expire() {
            LinkedList expireList = new LinkedList();
            Iterator<Element> iter = this.elements.iterator();
            while (iter.hasNext()) {
                Element element = iter.next();
                if (element.getRound() <= 0) {
                    expireList.add(element.getTarget());
                    iter.remove();
                    continue;
                }
                element.reduceRound();
            }
            return expireList;
        }

        public void remove(Object target) {
            int notFound = -1;
            int index = -1;
            for (int i = 0; i < this.elements.size(); ++i) {
                if (!this.elements.get(i).getTarget().equals(target)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                this.elements.remove(index);
            }
        }

        public String toString() {
            return "Slot{elements=" + this.elements + '}';
        }
    }
}

