/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.datasource;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import com.xforceplus.ultraman.oqsengine.common.datasource.DataSourcePackage;
import com.xforceplus.ultraman.oqsengine.common.pool.ExecutorHelper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.Metrics;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

public class DataSourceFactory {
    public static final String CONFIG_FILE = "ds";
    private static final String INDEX_WRITER_PATH = "dataSources.index.write";
    private static final String INDEX_SEARCH_PATH = "dataSources.index.search";
    private static final String MASTER_PATH = "dataSources.master";
    private static final String DEV_OPS_PATH = "dataSources.master";

    public static DataSourcePackage build() {
        return DataSourceFactory.build(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSourcePackage build(boolean showSql) {
        DataSource devOpsDataSource;
        String dsConfigFile = System.getProperty(CONFIG_FILE);
        ConfigFactory.invalidateCaches();
        Config config = dsConfigFile == null ? ConfigFactory.load((String)"oqsengine-ds.conf") : ConfigFactory.load((Config)ConfigFactory.parseFile((File)new File(dsConfigFile)));
        List<DataSource> indexWrite = config.hasPath(INDEX_WRITER_PATH) ? DataSourceFactory.buildDataSources("indexWrite", config.getConfigList(INDEX_WRITER_PATH), showSql) : Collections.emptyList();
        List<DataSource> indexSearch = config.hasPath(INDEX_SEARCH_PATH) ? DataSourceFactory.buildDataSources("indexSearch", config.getConfigList(INDEX_SEARCH_PATH), showSql) : Collections.emptyList();
        List<DataSource> master = config.hasPath("dataSources.master") ? DataSourceFactory.buildDataSources("master", config.getConfigList("dataSources.master"), showSql) : Collections.emptyList();
        if (config.hasPath("dataSources.master")) {
            List<DataSource> devOps = DataSourceFactory.buildDataSources("master", config.getConfigList("dataSources.master"), showSql);
            if (devOps.size() <= 0) throw new RuntimeException("devOps dataSource was been configure, but not init success");
            devOpsDataSource = devOps.get(0);
            return new DataSourcePackage(master, indexWrite, indexSearch, devOpsDataSource);
        } else {
            devOpsDataSource = null;
        }
        return new DataSourcePackage(master, indexWrite, indexSearch, devOpsDataSource);
    }

    private static List<DataSource> buildDataSources(String baseName, List<Config> configs, boolean showSql) {
        ArrayList<DataSource> ds = new ArrayList<DataSource>(configs.size());
        for (int i = 0; i < configs.size(); ++i) {
            ds.add(DataSourceFactory.buildDataSource(baseName + "-" + i, configs.get(i), showSql));
        }
        return ds;
    }

    private static DataSource buildDataSource(String name, Config config, boolean showSql) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        hikariConfig.setPoolName(name);
        hikariConfig.setMetricRegistry((Object)Metrics.globalRegistry);
        config.entrySet().stream().forEach(e -> {
            try {
                DataSourceFactory.invokeMethod(hikariConfig, (String)e.getKey(), (ConfigValue)e.getValue());
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Configuration error, wrong property '%s' '%s'.", e.getKey(), e.getValue()));
            }
        });
        if (showSql) {
            hikariConfig.setDriverClassName("com.p6spy.engine.spy.P6SpyDriver");
            String jdbcPreifx = "jdbc:";
            String loggerJdbcPrefix = "jdbc:p6spy:";
            if (!hikariConfig.getJdbcUrl().startsWith("jdbc:p6spy:")) {
                StringBuffer loggerJdbc = new StringBuffer();
                loggerJdbc.append("jdbc:p6spy:");
                loggerJdbc.append(hikariConfig.getJdbcUrl().substring("jdbc:".length()));
                hikariConfig.setJdbcUrl(loggerJdbc.toString());
            }
        }
        hikariConfig.setThreadFactory(ExecutorHelper.buildNameThreadFactory("jdbc-pool", false));
        return new HikariDataSource(hikariConfig);
    }

    private static void invokeMethod(HikariConfig hikariConfig, String attrName, ConfigValue value) throws Exception {
        Class<?> clazz = hikariConfig.getClass();
        String methodName = "set" + attrName.toUpperCase().substring(0, 1) + attrName.substring(1);
        Method method = null;
        switch (value.valueType()) {
            case NUMBER: {
                try {
                    method = clazz.getMethod(methodName, Long.TYPE);
                }
                catch (NoSuchMethodException ex) {
                    method = clazz.getMethod(methodName, Integer.TYPE);
                }
                break;
            }
            case STRING: {
                method = clazz.getMethod(methodName, String.class);
                break;
            }
            case BOOLEAN: {
                method = clazz.getMethod(methodName, Boolean.TYPE);
                break;
            }
            default: {
                throw new NoSuchMethodException(String.format("The '%s' property setting could not be found.", attrName));
            }
        }
        method.invoke((Object)hikariConfig, value.unwrapped());
    }
}

