/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.datasource;

import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import javax.sql.DataSource;

public class DataSourcePackage {
    private List<DataSource> master;
    private List<DataSource> indexWriter;
    private List<DataSource> indexSearch;
    private DataSource devOps;

    public DataSourcePackage(List<DataSource> master, List<DataSource> indexWriter, List<DataSource> indexSearch, DataSource devOps) {
        this.master = master;
        this.indexWriter = indexWriter;
        this.indexSearch = indexSearch;
        this.devOps = devOps;
    }

    public List<DataSource> getMaster() {
        return this.master;
    }

    public List<DataSource> getIndexWriter() {
        return this.indexWriter;
    }

    public List<DataSource> getIndexSearch() {
        return this.indexSearch;
    }

    public DataSource getDevOps() {
        return this.devOps;
    }

    public void close() {
        if (this.master != null) {
            this.doClose(this.master);
        }
        if (this.indexWriter != null) {
            this.doClose(this.indexWriter);
        }
        if (this.indexSearch != null) {
            this.doClose(this.indexSearch);
        }
        if (null != this.devOps) {
            ((HikariDataSource)this.devOps).close();
        }
    }

    private void doClose(List<DataSource> master) {
        for (DataSource ds : master) {
            ((HikariDataSource)ds).close();
        }
    }
}

