/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.datasource.log;

import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.appender.FormattedLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLogger
extends FormattedLogger {
    final Logger logger = LoggerFactory.getLogger((String)"sqlLogger");

    public void logException(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
    }

    public void logText(String text) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(text);
        }
    }

    public boolean isCategoryEnabled(Category category) {
        if (Category.ERROR.equals((Object)category)) {
            return this.logger.isErrorEnabled();
        }
        if (Category.WARN.equals((Object)category)) {
            return this.logger.isWarnEnabled();
        }
        if (Category.DEBUG.equals((Object)category)) {
            return this.logger.isDebugEnabled();
        }
        return this.logger.isInfoEnabled();
    }

    public void logSQL(int connectionId, String now, long elapsed, Category category, String prepared, String sql, String url) {
        if (this.logger.isInfoEnabled()) {
            String msg = this.strategy.formatMessage(connectionId, now, elapsed, category.toString(), prepared, sql, url);
            this.logger.info(msg);
        }
    }
}

