/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.id;

import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.micrometer.core.instrument.Metrics;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class RedisOrderContinuousLongIdGenerator
implements LongIdGenerator {
    private static final String DEFAULT_KEY = "com.xforceplus.ultraman.oqsengine.common.id";
    private StatefulRedisConnection<String, String> connection;
    private String key;
    private Supplier<Long> supplier;
    private AtomicLong commitIdNumber = (AtomicLong)Metrics.gauge((String)"oqs.now.commitid", (Number)new AtomicLong(0L));

    public RedisOrderContinuousLongIdGenerator(RedisClient redisClient) {
        this(redisClient, DEFAULT_KEY, () -> 0L);
    }

    public RedisOrderContinuousLongIdGenerator(RedisClient redisClient, Supplier<Long> supplier) {
        this(redisClient, DEFAULT_KEY, supplier);
    }

    public RedisOrderContinuousLongIdGenerator(RedisClient redisClient, String key, Supplier<Long> supplier) {
        this.key = key;
        this.connection = redisClient.connect();
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long next() {
        RedisCommands sync = this.connection.sync();
        Long newId = sync.incr((Object)this.key);
        try {
            Long l = newId;
            return l;
        }
        finally {
            Long finalNewId = newId;
            CompletableFuture.runAsync(() -> this.commitIdNumber.set(finalNewId));
        }
    }

    @PostConstruct
    public void init() {
        if (this.key == null || this.key.isEmpty()) {
            this.key = DEFAULT_KEY;
        }
        this.initializeId();
    }

    @PreDestroy
    public void destroy() {
        this.connection.close();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isPartialOrder() {
        return true;
    }

    private synchronized void initializeId() {
        RedisCommands sync = this.connection.sync();
        sync.setnx((Object)this.key, (Object)this.supplier.get().toString());
    }
}

