/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.lock;

import com.xforceplus.ultraman.oqsengine.common.lock.ResourceLocker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public abstract class AbstractResourceLocker
implements ResourceLocker {
    private static final long RETRY_DELAY = 50L;
    private final ThreadLocal<Map<String, String>> THREAD_INFO = new ThreadLocal();
    private long retryDelay = 0L;

    public long getRetryDelay() {
        return this.retryDelay <= 0L ? 50L : this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    @Override
    public void lock(String key) {
        boolean ok = false;
        String storeKey = this.buildStoreResourceKey(key);
        String lockingId = this.makeThreadId(key);
        long delay = this.getRetryDelay();
        while (!ok) {
            ok = this.doLock(storeKey, lockingId);
            if (ok) continue;
            try {
                this.await(delay);
            }
            catch (InterruptedException ex) {
                if (!ok) {
                    this.removeThreadId(key);
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public boolean tryLock(String key) {
        boolean result = this.doLock(this.buildStoreResourceKey(key), this.makeThreadId(key));
        if (!result) {
            this.removeThreadId(key);
        }
        return result;
    }

    @Override
    public boolean tryLock(String key, long time, TimeUnit unit) {
        if (time <= 0L) {
            return this.tryLock(key);
        }
        boolean ok = false;
        long timeout = unit.toMillis(time);
        long timePass = 0L;
        String storeKey = this.buildStoreResourceKey(key);
        String lockingId = this.makeThreadId(key);
        long delay = this.getRetryDelay();
        while (!ok) {
            ok = this.doLock(storeKey, lockingId);
            if (ok) continue;
            try {
                this.await(delay);
            }
            catch (InterruptedException ex) {
                if (!ok) {
                    this.removeThreadId(key);
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
            if ((timePass += delay) < timeout) continue;
        }
        if (!ok) {
            this.removeThreadId(key);
        }
        return ok;
    }

    @Override
    public boolean unlock(String key) {
        String storeKey = this.buildStoreResourceKey(key);
        String unLockingId = this.getThreadId(key);
        String lockingId = this.isLocked(storeKey);
        if (lockingId != null) {
            if (lockingId.equals(unLockingId)) {
                int result = this.doUnLock(storeKey);
                if (result == 0) {
                    this.removeThreadId(key);
                }
                return result >= 0;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getLockNumber(String key) {
        return this.doLockNumber(this.buildStoreResourceKey(key));
    }

    private void await(long time) throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(time);
    }

    private String buildStoreResourceKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Invalid resource lock.");
        }
        StringBuilder keyBuff = new StringBuilder();
        keyBuff.append("lock.mark#");
        keyBuff.append(key);
        return keyBuff.toString();
    }

    private String makeThreadId(String key) {
        String id;
        Map<String, String> idMap = this.THREAD_INFO.get();
        if (idMap == null) {
            idMap = new HashMap<String, String>();
            this.THREAD_INFO.set(idMap);
        }
        if ((id = idMap.get(key)) == null) {
            id = UUID.randomUUID().toString();
            idMap.put(key, id);
        }
        return id;
    }

    private String getThreadId(String key) {
        Map<String, String> idMap = this.THREAD_INFO.get();
        if (idMap == null) {
            return UUID.randomUUID().toString();
        }
        return idMap.get(key);
    }

    private void removeThreadId(String key) {
        Map<String, String> idMap = this.THREAD_INFO.get();
        idMap.remove(key);
        if (idMap.isEmpty()) {
            this.THREAD_INFO.remove();
        }
    }

    protected ThreadLocal getThreadLocal() {
        return this.THREAD_INFO;
    }

    protected abstract boolean doLock(String var1, String var2);

    protected abstract int doUnLock(String var1);

    protected abstract String isLocked(String var1);

    protected abstract int doLockNumber(String var1);
}

