/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.lock;

import com.xforceplus.ultraman.oqsengine.common.lock.AbstractResourceLocker;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LocalResourceLocker
extends AbstractResourceLocker {
    private final ConcurrentMap<String, LockInfo> lockPool = new ConcurrentHashMap<String, LockInfo>();

    @Override
    protected int doLockNumber(String key) {
        LockInfo info = (LockInfo)this.lockPool.get(key);
        if (info != null) {
            return info.getNumber();
        }
        return 0;
    }

    @Override
    protected boolean doLock(String key, String lockingId) {
        LockInfo newLockInfo = new LockInfo(lockingId);
        LockInfo oldLockInfo = this.lockPool.putIfAbsent(key, newLockInfo);
        if (oldLockInfo == null) {
            return true;
        }
        if (oldLockInfo.getLockingId().equals(lockingId)) {
            oldLockInfo.incr();
            return true;
        }
        return false;
    }

    @Override
    protected int doUnLock(String key) {
        LockInfo lockInfo = (LockInfo)this.lockPool.get(key);
        if (lockInfo != null) {
            int remaining = lockInfo.dec();
            if (remaining == 0) {
                this.lockPool.remove(key);
                return 0;
            }
            return remaining;
        }
        return -1;
    }

    @Override
    protected String isLocked(String key) {
        return ((LockInfo)this.lockPool.get(key)).getLockingId();
    }

    private static class LockInfo {
        private final String lockingId;
        private final AtomicInteger number;

        public LockInfo(String lockingId) {
            this.lockingId = lockingId;
            this.number = new AtomicInteger(1);
        }

        public String getLockingId() {
            return this.lockingId;
        }

        public int incr() {
            return this.number.incrementAndGet();
        }

        public int dec() {
            return this.number.decrementAndGet();
        }

        public int getNumber() {
            return this.number.intValue();
        }
    }
}

