/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.datasource.log;

import com.xforceplus.ultraman.oqsengine.common.StringUtils;
import com.xforceplus.ultraman.oqsengine.common.datasource.log.LoggerStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerPreparedStatement
extends LoggerStatement
implements PreparedStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"sqlLogger");
    private String sql;
    private int parameterLen = 0;
    private String[] parameter;
    private List<String[]> parameters;

    public LoggerPreparedStatement(PreparedStatement delegate, String sql) {
        super(delegate);
        int len = sql.length();
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            if ('?' == c) {
                ++this.parameterLen;
                buff.append("{}");
                continue;
            }
            buff.append(c);
        }
        this.sql = buff.toString();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBoolean(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Boolean.toString(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setByte(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Byte.toString(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setShort(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Short.toString(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setInt(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Integer.toString(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setLong(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Long.toString(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setFloat(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Float.toString(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setDouble(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Double.toString(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBigDecimal(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setString(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = StringUtils.encodeEscapeCharacters(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBytes(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = Arrays.toString(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setDate(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setDate(parameterIndex, x, cal);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setTime(parameterIndex, x, cal);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setTime(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setTimestamp(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setTimestamp(parameterIndex, x, cal);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setRef(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setArray(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setURL(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setRowId(parameterIndex, x);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = x.toString();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNString(parameterIndex, value);
        this.buildParameterBuffNotExist();
        this.parameter[parameterIndex - 1] = value;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setClob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBlob(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void close() throws SQLException {
        ((PreparedStatement)this.getDelegate()).close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setMaxRows(max);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getParameterMetaData();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setQueryTimeout(seconds);
    }

    @Override
    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.getDelegate()).clearParameters();
        this.parameter = null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        ((PreparedStatement)this.getDelegate()).addBatch(sql);
    }

    @Override
    public void addBatch() throws SQLException {
        ((PreparedStatement)this.getDelegate()).addBatch();
        if (this.parameters == null) {
            this.parameters = new ArrayList<String[]>();
        }
        this.parameters.add(this.parameter);
        this.parameter = null;
    }

    @Override
    public void cancel() throws SQLException {
        ((PreparedStatement)this.getDelegate()).cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        ((PreparedStatement)this.getDelegate()).clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setCursorName(name);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getMoreResults(current);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.parameters = null;
        ((PreparedStatement)this.getDelegate()).clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getConnection();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((PreparedStatement)this.getDelegate()).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        ((PreparedStatement)this.getDelegate()).setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((PreparedStatement)this.getDelegate()).getLargeMaxRows();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.logBatch();
        return ((PreparedStatement)this.getDelegate()).executeBatch();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.log();
        return ((PreparedStatement)this.getDelegate()).executeQuery();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(sql);
        }
        return ((PreparedStatement)this.getDelegate()).executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(sql);
        }
        return ((PreparedStatement)this.getDelegate()).executeUpdate(sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.log();
        return ((PreparedStatement)this.getDelegate()).executeUpdate();
    }

    @Override
    public boolean execute() throws SQLException {
        this.log();
        return ((PreparedStatement)this.getDelegate()).execute();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.logBatch();
        return ((PreparedStatement)this.getDelegate()).executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.log();
        return ((PreparedStatement)this.getDelegate()).executeLargeUpdate();
    }

    private void buildParameterBuffNotExist() {
        if (this.parameter == null) {
            this.parameter = new String[this.parameterLen];
        }
    }

    private void log() {
        if (this.parameter != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(this.sql, (Object[])this.parameter);
            }
            this.parameter = null;
        }
    }

    private void logBatch() {
        if (this.parameters != null) {
            if (LOGGER.isInfoEnabled()) {
                for (Object[] objectArray : this.parameters) {
                    LOGGER.info(this.sql, objectArray);
                }
            }
            this.parameters = null;
            this.parameter = null;
        }
    }
}

