/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.id;

import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class IncreasingOrderLongIdGenerator
implements LongIdGenerator {
    private static final String DEFAULT_NS = "com.xforceplus.ultraman.oqsengine.default";
    private ConcurrentMap<String, AtomicLong> pool;
    private long initId;

    public IncreasingOrderLongIdGenerator() {
        this(0L);
    }

    public IncreasingOrderLongIdGenerator(long initId) {
        initId = this.initId;
        this.pool = new ConcurrentHashMap<String, AtomicLong>();
        this.pool.put(DEFAULT_NS, new AtomicLong(initId));
    }

    @Override
    public Long next() {
        return this.next(DEFAULT_NS);
    }

    @Override
    public Long next(String nameSpace) {
        AtomicLong newLong = new AtomicLong(this.initId);
        AtomicLong old = this.pool.putIfAbsent(nameSpace, newLong);
        if (old == null) {
            return newLong.incrementAndGet();
        }
        return old.incrementAndGet();
    }

    @Override
    public Long current() {
        return this.current(DEFAULT_NS);
    }

    @Override
    public Long current(String nameSpace) {
        AtomicLong old = (AtomicLong)this.pool.get(nameSpace);
        if (old == null) {
            return 0L;
        }
        return old.get();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isPartialOrder() {
        return true;
    }

    @Override
    public void reset() {
        this.reset(DEFAULT_NS);
    }

    @Override
    public void reset(String ns) {
        AtomicLong old = this.pool.putIfAbsent(ns, new AtomicLong(this.initId));
        if (old != null) {
            old.set(0L);
        }
    }

    @Override
    public boolean supportNameSpace() {
        return true;
    }
}

