/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.id;

import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class RedisOrderContinuousLongIdGenerator
implements LongIdGenerator {
    private static final String DEFAULT_NAMESPACE = "com.xforceplus.ultraman.oqsengine.default";
    private StatefulRedisConnection<String, String> connection;
    private String ns;

    public RedisOrderContinuousLongIdGenerator(RedisClient redisClient) {
        this(redisClient, DEFAULT_NAMESPACE);
    }

    public RedisOrderContinuousLongIdGenerator(RedisClient redisClient, String ns) {
        this.ns = ns;
        this.connection = redisClient.connect();
    }

    @Override
    public Long next() {
        return this.next(this.ns);
    }

    @Override
    public Long next(String nameSpace) {
        RedisCommands sync = this.connection.sync();
        Long newId = sync.incr((Object)nameSpace);
        return newId;
    }

    @Override
    public Long current() {
        return this.current(this.ns);
    }

    @Override
    public Long current(String nameSpace) {
        RedisCommands sync = this.connection.sync();
        return sync.incrby((Object)nameSpace, 0L);
    }

    @Override
    public boolean supportNameSpace() {
        return true;
    }

    @PostConstruct
    public void init() {
        if (this.ns == null || this.ns.isEmpty()) {
            this.ns = DEFAULT_NAMESPACE;
        }
    }

    @PreDestroy
    public void destroy() {
        this.connection.close();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isPartialOrder() {
        return true;
    }

    @Override
    public void reset() {
        RedisCommands sync = this.connection.sync();
        sync.set((Object)this.ns, (Object)"0");
    }
}

