/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.load.loadfactor;

import com.xforceplus.ultraman.oqsengine.common.load.loadfactor.AbstractLoadFactor;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class CpuLoadFactor
extends AbstractLoadFactor {
    private static ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private volatile double load;
    private Thread monitorThread = new Thread(new MonitorTask());

    public CpuLoadFactor() {
        this(1.0);
    }

    public CpuLoadFactor(double weight) {
        super(weight);
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    @Override
    public double now() {
        return this.load;
    }

    class MonitorTask
    implements Runnable {
        MonitorTask() {
        }

        @Override
        public void run() {
            while (true) {
                long[] allThreadIds = Arrays.stream(THREAD_MX_BEAN.getAllThreadIds()).filter(id -> id != CpuLoadFactor.this.monitorThread.getId()).toArray();
                long[] startCpuTimes = Arrays.stream(allThreadIds).map(id -> THREAD_MX_BEAN.getThreadCpuTime(id)).toArray();
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long[] endCpuTimes = Arrays.stream(allThreadIds).map(id -> THREAD_MX_BEAN.getThreadCpuTime(id)).toArray();
                double usage = 0.0;
                for (int i = 0; i < allThreadIds.length; ++i) {
                    if (endCpuTimes[i] < 0L) continue;
                    usage += (double)((endCpuTimes[i] - startCpuTimes[i]) / 10000000L);
                }
                CpuLoadFactor.this.load = usage;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

