/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.parser.redis;

import com.xforceplus.ultraman.oqsengine.common.parser.KeyValueParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class RedisInfoParser
implements KeyValueParser<String, Map> {
    static final char SEGMENTATION_SYMBOLS = ':';
    public static final KeyValueParser<String, Map> INSTANCE = new RedisInfoParser();

    public static KeyValueParser<String, Map> getInstance() {
        return INSTANCE;
    }

    private RedisInfoParser() {
    }

    @Override
    public Map parse(String info) {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(info.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
        HashMap<String, String> infos = new HashMap<String, String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                int symbolsIndex = line.indexOf(58);
                infos.put(line.substring(0, symbolsIndex), line.substring(symbolsIndex + 1));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        return infos;
    }
}

