/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.selector;

import com.xforceplus.ultraman.oqsengine.common.hash.Time33Hash;
import com.xforceplus.ultraman.oqsengine.common.selector.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HashSelector<V>
implements Selector<V> {
    private List<V> targets;

    public HashSelector(Collection<V> targets) {
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("There are no optional elements.");
        }
        this.targets = new ArrayList<V>(targets);
    }

    @Override
    public V select(String key) {
        int address = Math.abs(Time33Hash.getInstance().hash(key) % this.targets.size());
        return this.targets.get(address);
    }

    @Override
    public List<V> selects() {
        return this.targets.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

