/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.watch;

import com.xforceplus.ultraman.oqsengine.common.lifecycle.Lifecycle;
import com.xforceplus.ultraman.oqsengine.common.timerwheel.TimeoutNotification;
import com.xforceplus.ultraman.oqsengine.common.timerwheel.TimerWheel;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLuaScriptWatchDog
implements Lifecycle {
    final Logger logger = LoggerFactory.getLogger(RedisLuaScriptWatchDog.class);
    private StatefulRedisConnection<String, String> connection;
    private RedisCommands<String, String> syncCommands;
    private ConcurrentMap<String, String> scripts;
    private TimerWheel<String> timerWheel;
    private long checkTimeIntervalMs;

    public RedisLuaScriptWatchDog(RedisClient redisClient) {
        this(redisClient, 60000L);
    }

    public RedisLuaScriptWatchDog(RedisClient redisClient, long checkTimeIntervalMs) {
        this.checkTimeIntervalMs = checkTimeIntervalMs;
        this.connection = redisClient.connect();
        this.syncCommands = this.connection.sync();
        this.scripts = new ConcurrentHashMap<String, String>();
        this.timerWheel = new TimerWheel<String>(new ShaTimeoutNotification());
    }

    @Override
    @PreDestroy
    public void destroy() throws Exception {
        this.timerWheel.destroy();
        this.connection.close();
    }

    public String watch(String lua) {
        String sha = this.syncCommands.scriptLoad(lua);
        this.addWatch(sha, lua);
        this.logger.info("Redis Lua Watch Dog starts to focus on scripts ({}).", (Object)lua);
        return sha;
    }

    public void ignore(String sha) {
        this.timerWheel.remove(sha);
        this.scripts.remove(sha);
    }

    private void notExistLoad(String key, Supplier<String> scriptBuilder) {
        if (!this.exist(key)) {
            String lua = scriptBuilder.get();
            String sha = this.syncCommands.scriptLoad(lua);
            this.addWatch(sha, lua);
            this.logger.info("{} scipt lost, restore.", (Object)lua);
        }
    }

    private void addWatch(String key, String lua) {
        String oldLua = this.scripts.putIfAbsent(key, lua);
        if (oldLua != null) {
            this.timerWheel.remove(key);
        }
        this.timerWheel.add(key, this.checkTimeIntervalMs);
    }

    private boolean exist(String sha) {
        List results = this.syncCommands.scriptExists(new String[]{sha});
        return (Boolean)results.get(0);
    }

    class ShaTimeoutNotification
    implements TimeoutNotification<String> {
        ShaTimeoutNotification() {
        }

        @Override
        public long notice(String sha) {
            if (RedisLuaScriptWatchDog.this.syncCommands.isOpen()) {
                String lua = (String)RedisLuaScriptWatchDog.this.scripts.get(sha);
                if (lua != null) {
                    RedisLuaScriptWatchDog.this.notExistLoad(sha, () -> lua);
                    return RedisLuaScriptWatchDog.this.checkTimeIntervalMs;
                }
                return 0L;
            }
            return RedisLuaScriptWatchDog.this.checkTimeIntervalMs;
        }
    }
}

