/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.mock;

import com.xforceplus.ultraman.oqsengine.common.datasource.DataSourceFactory;
import com.xforceplus.ultraman.oqsengine.common.datasource.DataSourcePackage;
import com.xforceplus.ultraman.oqsengine.common.mock.BeanInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.InitializationHelper;
import io.lettuce.core.RedisClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CommonInitialization
implements BeanInitialization {
    private static volatile CommonInitialization instance = null;
    private DataSourcePackage dataSourcePackage;
    private RedisClient redisClient;
    private ExecutorService runner;

    private CommonInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonInitialization getInstance() throws IllegalAccessException {
        if (null != instance) return instance;
        Class<CommonInitialization> clazz = CommonInitialization.class;
        synchronized (CommonInitialization.class) {
            if (null != instance) return instance;
            instance = new CommonInitialization();
            instance.init();
            InitializationHelper.add(instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void init() throws IllegalAccessException {
        this.runner = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024));
    }

    @Override
    public void clear() throws Exception {
        try {
            if (null != this.redisClient) {
                this.redisClient.connect().sync().flushall();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        if (null != this.redisClient) {
            this.redisClient.shutdown();
            this.redisClient = null;
        }
        if (null != this.dataSourcePackage) {
            this.dataSourcePackage.close();
            this.dataSourcePackage = null;
        }
        this.runner.shutdown();
        this.runner = null;
        instance = null;
    }

    public synchronized DataSourcePackage getDataSourcePackage(boolean showSql) {
        if (null == this.dataSourcePackage) {
            this.dataSourcePackage = DataSourceFactory.build(showSql);
        }
        return this.dataSourcePackage;
    }

    public synchronized RedisClient getRedisClient() {
        if (null == this.redisClient) {
            this.redisClient = RedisClient.create((String)String.format("redis://%s:%s", System.getProperty("REDIS_HOST"), System.getProperty("REDIS_PORT")));
        }
        return this.redisClient;
    }

    public ExecutorService getRunner() {
        return this.runner;
    }
}

