/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.common.id;

import com.xforceplus.ultraman.oqsengine.common.id.ClockBackwardsException;
import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.node.NodeIdGenerator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class SnowflakeLongIdGenerator
implements LongIdGenerator {
    public static final int NODE_SHIFT = 10;
    public static final int SEQ_SHIFT = 12;
    public static final short MAX_NODE = 1023;
    public static final short MAX_SEQUENCE = 4095;
    private short sequence;
    private long referenceTime;
    private long twepoch = 1288834974657L;
    private int node;
    private volatile long currentValue;

    public SnowflakeLongIdGenerator(NodeIdGenerator nodeIdGenerator) {
        int nodeId = (Integer)nodeIdGenerator.next();
        if (nodeId < 0 || nodeId > 1023) {
            throw new IllegalArgumentException(String.format("node is between %s and %s", 0, (short)1023));
        }
        this.node = nodeId;
        this.currentValue = 0L;
    }

    public SnowflakeLongIdGenerator(NodeIdGenerator nodeIdGenerator, int offset) {
        int nodeId = (Integer)nodeIdGenerator.next() + offset;
        if (nodeId < 0 || nodeId > 1023) {
            throw new IllegalArgumentException(String.format("node is between %s and %s", 0, (short)1023));
        }
        this.node = nodeId;
        this.currentValue = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long next() {
        long counter;
        long currentTime;
        SnowflakeLongIdGenerator snowflakeLongIdGenerator = this;
        synchronized (snowflakeLongIdGenerator) {
            currentTime = System.currentTimeMillis();
            if (currentTime < this.referenceTime) {
                long offset = this.referenceTime - currentTime;
                if (offset <= 5L) {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(offset << 1));
                    currentTime = this.timeGen();
                    if (currentTime < this.referenceTime) {
                        throw new ClockBackwardsException(this.referenceTime, currentTime);
                    }
                } else {
                    throw new ClockBackwardsException(this.referenceTime, currentTime);
                }
            }
            if (currentTime > this.referenceTime) {
                this.sequence = 0;
            } else if (this.sequence < 4095) {
                this.sequence = (short)(this.sequence + 1);
            } else {
                currentTime = this.tilNextMillis(this.referenceTime);
            }
            counter = this.sequence;
            this.referenceTime = currentTime;
        }
        long value = currentTime - this.twepoch << 10 << 12 | (long)(this.node << 12) | counter;
        SnowflakeLongIdGenerator snowflakeLongIdGenerator2 = this;
        synchronized (snowflakeLongIdGenerator2) {
            this.currentValue = value;
        }
        return value;
    }

    @Override
    public Long current() {
        return this.currentValue;
    }

    private Long timeGen() {
        return System.currentTimeMillis();
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isPartialOrder() {
        return true;
    }
}

