/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.devops.om.util;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import com.xforceplus.ultraman.oqsengine.pojo.utils.TimeUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;

public class DevOpsOmDataUtils {
    public static Object convertDataObject(IEntityField field, Object result) {
        try {
            switch (field.type()) {
                case BOOLEAN: {
                    if (result instanceof String) {
                        result = Boolean.valueOf((String)result);
                    }
                    return result;
                }
                case DATETIME: {
                    if (result instanceof Date) {
                        return TimeUtils.convert((Date)((Date)result)).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                    }
                    if (result instanceof LocalDateTime) {
                        return ((LocalDateTime)result).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                    }
                    if (result instanceof String) {
                        result = Long.valueOf((String)result);
                    }
                    return TimeUtils.convert((Long)((Long)result));
                }
                case LONG: {
                    if (result instanceof Integer) {
                        result = ((Integer)result).longValue();
                    } else if (result instanceof String) {
                        result = Long.parseLong((String)result);
                    }
                    return result;
                }
                case ENUM: 
                case STRING: {
                    return result;
                }
                case STRINGS: {
                    return StringsValue.toStrings((String)((String)result));
                }
                case DECIMAL: {
                    if (result instanceof Integer) {
                        result = new BigDecimal(result.toString());
                    } else if (result instanceof Double) {
                        result = BigDecimal.valueOf((Double)result);
                    } else if (result instanceof String) {
                        result = new BigDecimal((String)result);
                    }
                    return result;
                }
            }
            throw new IllegalArgumentException("unknown field type.");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("field[%s-%s] toIValue failed, message [%s]", field.name(), field.type(), e.getMessage()));
        }
    }

    public static ConditionOperator convertOperation(String operation) {
        switch (operation) {
            case "eq": {
                return ConditionOperator.EQUALS;
            }
            case "ne": {
                return ConditionOperator.NOT_EQUALS;
            }
            case "like": {
                return ConditionOperator.LIKE;
            }
            case "in": {
                return ConditionOperator.MULTIPLE_EQUALS;
            }
            case "gt": {
                return ConditionOperator.GREATER_THAN;
            }
            case "ge": {
                return ConditionOperator.GREATER_THAN_EQUALS;
            }
            case "lt": {
                return ConditionOperator.LESS_THAN;
            }
            case "le": {
                return ConditionOperator.LESS_THAN_EQUALS;
            }
            case "exists": {
                return ConditionOperator.IS_NOT_NULL;
            }
            case "nil": {
                return ConditionOperator.IS_NULL;
            }
        }
        return null;
    }
}

