/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.devops.rebuild.handler;

import com.xforceplus.ultraman.oqsengine.devops.rebuild.handler.TaskHandler;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.model.DevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.storage.SQLTaskStorage;

public class DefaultDevOpsTaskHandler
implements TaskHandler {
    protected DevOpsTaskInfo devOpsTaskInfo;
    private SQLTaskStorage sqlTaskStorage;

    public DefaultDevOpsTaskHandler(SQLTaskStorage sqlTaskStorage, DevOpsTaskInfo taskInfo) {
        this.devOpsTaskInfo = taskInfo;
        this.sqlTaskStorage = sqlTaskStorage;
    }

    @Override
    public String id() {
        return String.valueOf(this.devOpsTaskInfo.id());
    }

    @Override
    public boolean isDone() {
        if (!this.devOpsTaskInfo.isDone()) {
            this.flush();
        }
        return this.devOpsTaskInfo.isDone();
    }

    @Override
    public boolean isError() {
        if (!this.devOpsTaskInfo.isDone()) {
            this.flush();
        }
        return this.devOpsTaskInfo.isError();
    }

    @Override
    public long getProgressPercentage() {
        if (!this.isDone()) {
            return this.devOpsTaskInfo.getProgressPercentage();
        }
        return 100L;
    }

    @Override
    public DevOpsTaskInfo devOpsTaskInfo() {
        return this.devOpsTaskInfo;
    }

    private void flush() {
        try {
            this.sqlTaskStorage.selectUnique(this.devOpsTaskInfo.getMaintainid()).ifPresent(opsTaskInfo -> {
                this.devOpsTaskInfo.setBatchSize(opsTaskInfo.getBatchSize());
                this.devOpsTaskInfo.setFinishSize(opsTaskInfo.getFinishSize());
                this.devOpsTaskInfo.setErrorSize(opsTaskInfo.getErrorSize());
                this.devOpsTaskInfo.resetStatus(opsTaskInfo.getStatus());
                this.devOpsTaskInfo.resetMessage(opsTaskInfo.message());
                this.devOpsTaskInfo.resetUpdateTime(opsTaskInfo.updateTime());
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

