/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.devops.rebuild.mock;

import com.xforceplus.ultraman.oqsengine.common.id.LongIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.SnowflakeLongIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.id.node.StaticNodeIdGenerator;
import com.xforceplus.ultraman.oqsengine.common.mock.BeanInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.CommonInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.InitializationHelper;
import com.xforceplus.ultraman.oqsengine.common.mock.ReflectionUtils;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.DevOpsRebuildIndexExecutor;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.storage.SQLTaskStorage;
import com.xforceplus.ultraman.oqsengine.storage.index.sphinxql.mock.IndexInitialization;
import com.xforceplus.ultraman.oqsengine.storage.master.mock.MasterDBInitialization;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collection;
import javax.sql.DataSource;

public class RebuildInitialization
implements BeanInitialization {
    private static volatile RebuildInitialization instance = null;
    private DevOpsRebuildIndexExecutor taskExecutor;
    private DataSource devOpsDataSource;
    private LongIdGenerator idGenerator;
    private static final String DEVOPS_TABLE_NAME = "devopstasks";

    private RebuildInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RebuildInitialization getInstance() throws Exception {
        if (null != instance) return instance;
        Class<RebuildInitialization> clazz = RebuildInitialization.class;
        synchronized (RebuildInitialization.class) {
            if (null != instance) return instance;
            instance = new RebuildInitialization();
            instance.init();
            InitializationHelper.add((BeanInitialization)instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() throws Exception {
        this.idGenerator = new SnowflakeLongIdGenerator((NodeIdGenerator)new StaticNodeIdGenerator(0));
        this.devOpsDataSource = this.buildDevOpsDataSource();
        SQLTaskStorage sqlTaskStorage = new SQLTaskStorage();
        Collection fields = ReflectionUtils.printAllMembers((Object)sqlTaskStorage);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"devOpsDataSource", (Object)sqlTaskStorage, (Object)this.devOpsDataSource);
        sqlTaskStorage.setTable(DEVOPS_TABLE_NAME);
        this.taskExecutor = new DevOpsRebuildIndexExecutor(10, 1024);
        Collection taskFields = ReflectionUtils.printAllMembers((Object)this.taskExecutor);
        ReflectionUtils.reflectionFieldValue((Collection)taskFields, (String)"indexStorage", (Object)this.taskExecutor, (Object)IndexInitialization.getInstance().getIndexStorage());
        ReflectionUtils.reflectionFieldValue((Collection)taskFields, (String)"sqlTaskStorage", (Object)this.taskExecutor, (Object)sqlTaskStorage);
        ReflectionUtils.reflectionFieldValue((Collection)taskFields, (String)"masterStorage", (Object)this.taskExecutor, (Object)MasterDBInitialization.getInstance().getMasterStorage());
        ReflectionUtils.reflectionFieldValue((Collection)taskFields, (String)"idGenerator", (Object)this.taskExecutor, (Object)this.idGenerator);
    }

    public void clear() throws Exception {
        try (Connection conn = this.devOpsDataSource.getConnection();
             Statement st = conn.createStatement();){
            st.executeUpdate("truncate table devopstasks");
        }
    }

    public void destroy() throws Exception {
        this.taskExecutor.destroy();
        this.devOpsDataSource = null;
        this.idGenerator = null;
        instance = null;
    }

    private DataSource buildDevOpsDataSource() throws IllegalAccessException {
        return CommonInitialization.getInstance().getDataSourcePackage(false).getDevOps();
    }

    private DataSource buildMasterDataSource() throws IllegalAccessException {
        return (DataSource)CommonInitialization.getInstance().getDataSourcePackage(false).getMaster().get(0);
    }

    public DevOpsRebuildIndexExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public DataSource getDevOpsDataSource() {
        return this.devOpsDataSource;
    }

    public LongIdGenerator getIdGenerator() {
        return this.idGenerator;
    }
}

