/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.devops.rebuild.model;

import com.xforceplus.ultraman.oqsengine.devops.rebuild.enums.BatchStatus;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.model.DevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;

public class DefaultDevOpsTaskInfo
implements DevOpsTaskInfo {
    private long maintainid;
    private long entity;
    private long starts;
    private long ends;
    private long batchSize;
    private volatile int finishSize;
    private volatile int errorSize;
    private volatile int status;
    private long createTime;
    private long updateTime;
    private String message = "";
    private int incrementSize;
    private IEntityClass entityClass;

    public DefaultDevOpsTaskInfo() {
        this.incrementSize = 0;
    }

    public DefaultDevOpsTaskInfo(long maintainId, IEntityClass entityClass, long starts, long ends) {
        this(maintainId, entityClass.id(), starts, ends, 0, 0, BatchStatus.PENDING.getCode(), System.currentTimeMillis(), 0L);
        this.entityClass = entityClass;
        this.message = "TASK INIT";
        this.incrementSize = 0;
    }

    public DefaultDevOpsTaskInfo(long maintainId, long entity, long starts, long ends, int batchSize, int finishSize, int status, long createTime, long updateTime) {
        this.maintainid = maintainId;
        this.entity = entity;
        this.starts = starts;
        this.ends = ends;
        this.batchSize = batchSize;
        this.finishSize = finishSize;
        this.status = status;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.incrementSize = 0;
    }

    @Override
    public long updateTime() {
        return this.updateTime;
    }

    @Override
    public long getMaintainid() {
        return this.maintainid;
    }

    @Override
    public long getEntity() {
        return this.entity;
    }

    @Override
    public long getStarts() {
        return this.starts;
    }

    @Override
    public long getEnds() {
        return this.ends;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public IEntityClass getEntityClass() {
        return this.entityClass;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getFinishSize() {
        return this.finishSize;
    }

    @Override
    public int getErrorSize() {
        return this.errorSize;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public void resetMessage(String message) {
        if (null != message) {
            this.message = message.length() > 500 ? message.substring(0, 500) : message;
        }
    }

    @Override
    public void resetStatus(int status) {
        this.status = status;
    }

    @Override
    public void setFinishSize(int finishSize) {
        this.finishSize = finishSize;
    }

    @Override
    public void addFinishSize(int addSize) {
        this.finishSize += addSize;
    }

    @Override
    public void setErrorSize(long size) {
        this.errorSize = Long.valueOf(size).intValue();
    }

    @Override
    public void addErrorSize(int errorSize) {
        this.errorSize += errorSize;
    }

    @Override
    public void resetUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String id() {
        return Long.toString(this.maintainid);
    }

    @Override
    public boolean isDone() {
        return this.status == BatchStatus.DONE.getCode() || this.batchSize == (long)this.finishSize && this.batchSize > 0L;
    }

    @Override
    public boolean isError() {
        return this.status == BatchStatus.ERROR.getCode();
    }

    @Override
    public boolean isCancel() {
        return this.status == BatchStatus.CANCEL.getCode();
    }

    @Override
    public BatchStatus status() {
        return BatchStatus.toBatchStatus(this.status);
    }

    @Override
    public boolean isEnd() {
        return this.isDone() || this.isError() || this.isCancel();
    }

    @Override
    public long getProgressPercentage() {
        return 0L < this.batchSize ? (long)this.finishSize * 100L / this.batchSize : 0L;
    }

    @Override
    public void setBatchSize(long size) {
        this.batchSize = size;
    }

    @Override
    public int incrementSize() {
        return this.incrementSize;
    }

    @Override
    public void resetIncrementSize(int incrementSize) {
        this.incrementSize = incrementSize;
    }
}

