/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.devops.rebuild.storage;

import com.xforceplus.ultraman.oqsengine.devops.rebuild.enums.BatchStatus;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.model.DefaultDevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.model.DevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.storage.TaskStorage;
import com.xforceplus.ultraman.oqsengine.devops.rebuild.storage.TaskStorageCommand;
import com.xforceplus.ultraman.oqsengine.pojo.page.Page;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTaskStorage
implements TaskStorage {
    final Logger logger = LoggerFactory.getLogger(SQLTaskStorage.class);
    @Resource(name="devOpsDataSource")
    private DataSource devOpsDataSource;
    private String table = "devopstasks";

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Integer build(DevOpsTaskInfo taskInfo) throws SQLException {
        Collection<DevOpsTaskInfo> collection = this.selectActive(taskInfo.getEntity());
        if (0 != collection.size()) {
            for (DevOpsTaskInfo devOpsTaskInfo : collection) {
                this.cancel(devOpsTaskInfo.getMaintainid());
            }
        }
        return new TaskStorageCommand(this.table).build(this.devOpsDataSource, taskInfo);
    }

    @Override
    public int update(DevOpsTaskInfo taskInfo) throws SQLException {
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, (DefaultDevOpsTaskInfo)taskInfo);
    }

    @Override
    public int done(DevOpsTaskInfo taskInfo) throws SQLException {
        taskInfo.resetStatus(BatchStatus.DONE.getCode());
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, (DefaultDevOpsTaskInfo)taskInfo);
    }

    @Override
    public int error(DevOpsTaskInfo taskInfo) throws SQLException {
        taskInfo.resetStatus(BatchStatus.ERROR.getCode());
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, (DefaultDevOpsTaskInfo)taskInfo);
    }

    @Override
    public int cancel(long taskId) throws SQLException {
        return new TaskStorageCommand(this.table).status(this.devOpsDataSource, taskId, BatchStatus.CANCEL, "task canceled");
    }

    @Override
    public Collection<DevOpsTaskInfo> selectActive(long entityClassId) throws SQLException {
        return new TaskStorageCommand(this.table).selectActive(this.devOpsDataSource, entityClassId);
    }

    @Override
    public Optional<DevOpsTaskInfo> selectUnique(long taskId) throws SQLException {
        return new TaskStorageCommand(this.table).selectByUnique(this.devOpsDataSource, taskId);
    }

    @Override
    public Collection<DevOpsTaskInfo> listActives(Page page) throws SQLException {
        return new TaskStorageCommand(this.table).listActives(this.devOpsDataSource, page);
    }

    @Override
    public Collection<DevOpsTaskInfo> listAll(Page page) throws SQLException {
        return new TaskStorageCommand(this.table).listAll(this.devOpsDataSource, page);
    }
}

